//
// Test3
//
// This program tests the Random class by generating
// attributes for Dungeons and Dragons(tm) characters.
//
// Version 1.0, 1991 May 30
//
// Written by Gregor Purdy
// gregor@oit.itd.umich.edu
//
// See the README and COPYING files included for
// information and distribution and usage rights. 
//


#import <stdio.h>
#import "Random.h"


// #define ROLLFOREVER


void PrintAttrRoll(char *what, int roll1, int roll2)
{
    printf("%s: ", what);
    
    if (roll1 == 100)
        printf("00");
    else
        printf("%d", roll1);
	
    if (roll2 != 0)
	if (roll2 == 100)
	    printf("/00");
	else
	    printf("/%d", roll2);
    
    printf("\n");
}


void PrintPercentRoll(char *what, int roll)
{
    printf("%s: ", what);
    
    if (roll == 100)
        printf("00");
    else {
        if (roll < 10)
	    printf("0");
        printf("%d", roll);
    }
    
    printf("\n");
}


#define RollAttr	[roller rollBest:3 of:7 die:6]
#define RollPercent	[roller rollDie:100]
#define	NoRoll		0


int main(int argc, char *argv[])
{
    Random *roller;			// Roller to use for this test
    int roll;				// Die roll result
        
    roller = [[Random alloc] init];
    
#ifdef ROLLFOREVER
for(;;) {
#endif

    printf("\nATTRIBUTES\n");
    
    if ((roll = RollAttr) == 18)
    	PrintAttrRoll("Str", roll, RollPercent);
    else
	PrintAttrRoll("Str", roll, NoRoll);
    
    PrintAttrRoll("Int", RollAttr, NoRoll);
    PrintAttrRoll("Wis", RollAttr, NoRoll);
    PrintAttrRoll("Dex", RollAttr, NoRoll);
    PrintAttrRoll("Con", RollAttr, NoRoll);
    PrintAttrRoll("Cha", RollAttr, NoRoll);
    
    printf("\nOTHER\n");
    
    PrintPercentRoll("Soc", RollPercent);
    PrintPercentRoll("Psi", RollPercent);
    PrintPercentRoll("Msc", RollPercent);
    PrintPercentRoll("XXX", RollPercent);
    
    printf("\n");
    
#ifdef ROLLFOREVER
printf("\n");
}
#endif

    return 0;
}


//
// End of file.
//