/*************************************************************************
*		Copyright (c) 1989,1990 Stone Design Corp.  All rights reserved. 
***************************************************************************/


#import <appkit/SliderCell.h>

@interface SliderCellFine:SliderCell
{ 
	id  textPal;			// cached for speed & archive

	double altStep;			// these could be doubles
	double defaultValue;
	double defaultMax;
	double defaultMin;
	struct _scfFlags {
		unsigned int isWhole:1;			/* whether integer format */
		unsigned int isDecimal:1;		/* whether currently in decimal mode */
		unsigned int allowLower:1;		/* whether can go lower than min */
		unsigned int allowHigher:1;		/* whether can go higher than max */
		unsigned int sendContinuously:1;/* whether we send action always */
		unsigned int PADDING:11;		/* pad to 16 */
    } scfFlags;
}

+ new;      

- increment;
- decrement;

- (double)checkValue:(double)val;
- (BOOL) isDecimal;

- (BOOL)continueTracking:(const NXPoint *)lastPoint   // here is the work!
		      at:(const NXPoint *)currentPoint
		      inView:controlView;
		      
- setAltStep:(double)step whole:(BOOL)flag default:(double)val;
- setMax:(double)max allowHigher:(BOOL)hi min:(double)min allowLower:(BOOL)lo;

// archive methods: 
  
- read:(NXTypedStream *)stream;
- write:(NXTypedStream *)stream;

- _setAlwaysSendUpAction:(BOOL)flag;

- setDefault:(double) def;
- setTextPal:anObject;
@end
