
// Article.m -

#import "Article.h"

@implementation Article

+ new
{ 
  self = [super new];
  seen = TRUE;
  shown = FALSE;
  bogus = FALSE;
  
  cellStrings[ARTICLE_NUMBER] = numberString;
  cellStrings[ARTICLE_SUBJECT] = subject = name;
  
  subject[0] = '\0';
  
  return self;
}

+ newNumber:(long)newNumber
{
  self = [Article new];
  number = newNumber;
  sprintf(numberString, "%d", newNumber);
  
  return self;
}

+ newNumber:(long)newNumber subject:(const char *)newSubject
{
  self = [Article new];
  strcpy(subject, newSubject);
  [self setNumber:newNumber];

  return self;
}

- setNumber:(long)newNumber
{
  number = newNumber;
  sprintf(numberString, "%d", newNumber);
  
  return self;
}

- setSeen:(BOOL)newSeen
{
  seen = newSeen;
  
  if (!seen)
    cellBitmaps[ARTICLE_UNSEEN] = [Bitmap findBitmapFor:"unseen"];
  else
    cellBitmaps[ARTICLE_UNSEEN] = nil;
}


@end
