// ArticleDisplay.h --

#import <appkit/ScrollView.h>
#import <appkit/Text.h>
#import <appkit/TextFieldCell.h>
#import <appkit/Cursor.h>

#import <strings.h>
#import <ctype.h>
#import "response_codes.h"

#import "Article.h"
#import "ArticlesMatrix.h"
#import "NewsgroupsMatrix.h"

#import <objc/Object.h>

typedef enum {
  DATE, FOLLOWUP_TO, NEWSGROUPS, SUBJECT, SUMMARY, KEYWORDS,
  ORGANIZATION, FROM, REPLY_TO, FIELD_COUNT
} FieldsEnum;

@interface ArticleDisplay:Object
{
  id	bodyText;

  id	field[FIELD_COUNT];
  BOOL	bogusField[FIELD_COUNT];
  
  FILE		*nntpFile;
  Article	*selectedArticle;

  // UNUSED.  Here to please IB.
  id	dateDisplay;
  id	followupToTextField;
  id	newsgroupsTextField;
  id	subjectTextField;
  id	summaryTextField;
  id	keywordsTextField;
  id	organizationTextField;
  id	fromTextField;
  id	replyToTextField;
@public
  BOOL	verbose;
  BOOL	rot;
}

+ new;

- setupNNTP:(FILE *)newnntpFile;
- clear;

- readArticle;
- setArticle:sender;
- setVerbose:sender;
- setRot:sender;

- setFollowupToTextField:anObject;
- setDateDisplay:anObject;
- setNewsgroupsTextField:anObject;
- setSubjectTextField:anObject;
- setSummaryTextField:anObject;
- setKeywordsTextField:anObject;
- setOrganizationTextField:anObject;
- setFromTextField:anObject;
- setReplyToTextField:anObject;
- setBodyText:anObject;

@end
