
/* Generated by Interface Builder */
#import <appkit/NXImage.h>
#import "CalendarView.h"

@implementation CalendarView

- initFrame:(NXRect *)frameRect
{
    [super initFrame:frameRect];
    
    panelImage = [NXImage findImageNamed:"Panel"];

    numbers[0] = [NXImage findImageNamed:"Zero"];
    numbers[1] = [NXImage findImageNamed:"One"];
    numbers[2] = [NXImage findImageNamed:"Two"];
    numbers[3] = [NXImage findImageNamed:"Three"];
    numbers[4] = [NXImage findImageNamed:"Four"];
    numbers[5] = [NXImage findImageNamed:"Five"];
    numbers[6] = [NXImage findImageNamed:"Six"];
    numbers[7] = [NXImage findImageNamed:"Seven"];
    numbers[8] = [NXImage findImageNamed:"Eight"];
    numbers[9] = [NXImage findImageNamed:"Nine"];
    
    days[0] = [NXImage findImageNamed:"Sun"];
    days[1] = [NXImage findImageNamed:"Mon"];
    days[2] = [NXImage findImageNamed:"Tue"];
    days[3] = [NXImage findImageNamed:"Wed"];
    days[4] = [NXImage findImageNamed:"Thu"];
    days[5] = [NXImage findImageNamed:"Fri"];
    days[6] = [NXImage findImageNamed:"Sat"];
    
    months[0] = [NXImage findImageNamed:"Jan"];
    months[1] = [NXImage findImageNamed:"Feb"];
    months[2] = [NXImage findImageNamed:"Mar"];
    months[3] = [NXImage findImageNamed:"Apr"];
    months[4] = [NXImage findImageNamed:"May"];
    months[5] = [NXImage findImageNamed:"Jun"];
    months[6] = [NXImage findImageNamed:"Jul"];
    months[7] = [NXImage findImageNamed:"Aug"];
    months[8] = [NXImage findImageNamed:"Sep"];
    months[9] = [NXImage findImageNamed:"Oct"];
    months[10] = [NXImage findImageNamed:"Nov"];
    months[11] = [NXImage findImageNamed:"Dec"];
    
    day = 23;
    dayOfWeek = 5;
    month = 5;
    
    return self;
}

- setMonth:sender
{
    month = [sender intValue];
    [self display];
    return self;
}

- setDay:sender
{
    day = [sender intValue];
    [self display];
    return self;
}

- setDayNum:sender
{
    dayOfWeek = [sender intValue];
    [self display];
    return self;
}

- drawSelf:(NXRect *)rects :(int)count
{
    NXSize	panelSize, unitSize, tenSize, size;
    NXPoint	position;
    float	numberWidth;
    
    [panelImage composite:NX_COPY toPoint:&(bounds.origin)];
    
    [panelImage getSize:&panelSize];
    [numbers[day % 10] getSize:&unitSize];
    numberWidth = unitSize.width;
    if (day / 10) {
      [numbers[day / 10] getSize:&tenSize];
      numberWidth += tenSize.width;
    } else {
      tenSize.width = 0;
    }
    
    position.x = (panelSize.width - numberWidth) / 2 - 1.5;
    position.y = 15.0;
    
    if (day / 10) {
      [numbers[day / 10] composite:NX_COPY toPoint:&position];
    }
    
    position.x += tenSize.width;
    [numbers[day % 10] composite:NX_COPY toPoint:&position];
    
    [days[dayOfWeek] getSize:&size];
    position.x = (panelSize.width - size.width) / 2 - 1.5;
    position.y = 34;
    [days[dayOfWeek] composite:NX_COPY toPoint:&position];
    
    /* draw the month */
    [months[month] getSize:&size];
    position.x = (panelSize.width - size.width) / 2 - 2.5;
    position.y = 9;
    [months[month] composite:NX_COPY toPoint:&position];
    
    return self;
}

@end
