#import "RASF.h"
#import <stdio.h>
#import <stdlib.h>
#import <libc.h>
#import <zone.h>
#import <mach.h>
#import <appkit/Window.h>
#import <appkit/Panel.h>
#import <appkit/tiff.h>
#import "rasf_io.h"

// RASF.m 
// 
// Written by Vince DeMarco 
// 	demarco@cpsc.ucalgary.ca
//
// This program is In the Public Domain. If you make any improvements to this
// program please let me know
// 

@implementation RASF:View

- init
{
    self = [super init];
    newZone = NXCreateZone(vm_page_size,vm_page_size,NO);
    return(self);
}

-open:(char *)fileName
{
    int                 position,length;
    unsigned char       temp_rbuf[8192];
    unsigned char       temp_gbuf[8192];
    unsigned char       temp_bbuf[8192];
    unsigned char       erase_red,erase_grn,erase_blu,erase;
    FILE               *input_file;

    thisview = self;
    rmap = 0;

    if ((input_file = fopen(fileName,"r")) == NULL) {
	NXRunAlertPanel("RASF ERROR", "Can't open %s", NULL, NULL, NULL, fileName);
	return(self);
    }

    rle_reset();
    //Read in the header from the RASF file
    if(get_rle_header(input_file,&xsize,&ysize,&erase_red,&erase_grn,&erase_blu,&erase) == 0){
	NXRunAlertPanel("RASF ERROR", "%s Not an RASF file ", NULL, NULL, NULL, fileName);
	return(self);
    }

    r = (unsigned char *)NXZoneMalloc(newZone,ysize*xsize*(sizeof(unsigned char)));
    g = (unsigned char *)NXZoneMalloc(newZone,ysize*xsize*(sizeof(unsigned char)));
    b = (unsigned char *)NXZoneMalloc(newZone,ysize*xsize*(sizeof(unsigned char)));

    // Read each scan line into memory ready for displaying. 
    position = 0;
    bzero(temp_rbuf,8192);
    bzero(temp_gbuf,8192);
    bzero(temp_bbuf,8192);
    while(get_rle_run(input_file,temp_rbuf,temp_gbuf,temp_bbuf,&length)){
	bcopy(temp_rbuf,&r[position],length);
	bcopy(temp_gbuf,&g[position],length);
	bcopy(temp_bbuf,&b[position],length);
	position += (length);
    }
    fclose(input_file);
    NXSetRect(&temprect, 150.0, (800.0 - (double)ysize),(double)xsize, (double)ysize);

    thiswindow = [Window
		  newContent:&temprect
		  style:NX_TITLEDSTYLE
		  backing:NX_RETAINED
		  buttonMask:NX_CLOSEBUTTONMASK | NX_MINIATURIZEBUTTONMASK | NX_RESIZEBUTTONMASK
		  defer:NO];
    [thiswindow setTitleAsFilename:fileName];
    [thiswindow orderFront:nil];
    [thiswindow display];
    NXPing();

    rmap = r;
    gmap = g;
    bmap = b;

    [[thiswindow setContentView:self] free];
    [thiswindow display];
    return(self);
}

- drawSelf:(const NXRect *)rects :(int)rectCount
{
    if (rmap == 0)         // Check if there is anything to display if there isn't
	return self;       // just return

    [self getFrame:&temprect];
    temprect.origin.x = 0.0;
    temprect.origin.y = 0.0;
    [self lockFocus];
    NXImageBitmap(&temprect, xsize, ysize, 8, 3, NX_PLANAR, NX_COLORMASK, rmap, gmap, bmap, 0, 0);
    [self unlockFocus];
    return self;
}

- free
{
    NXDestroyZone(newZone);
    [super free];
    return(self);
}

@end
