#import "RLE.h"
#import <stdio.h>
#import <stdlib.h>
#import <zone.h>
#import <mach.h>
#import <rle.h>
#import <appkit/Window.h>
#import <appkit/Panel.h>
#import <appkit/tiff.h>

// RLE.m 
// 
// Written by Vince DeMarco 
// 	demarco@cpsc.ucalgary.ca
//
// This program is In the Public Domain. If you make any improvements to this
// program please let me know
// 

@implementation RLE:View

- init
{
    self = [super init];
    newZone = NXCreateZone(vm_page_size,vm_page_size,NO);
    return(self);
}

-open:(char *)fileName
{
    int                 i,j,row_pos;

    rle_pixel  **scan;

    thisview = self;
    rmap = 0;

    rle_dflt_hdr.rle_file = rle_open_f_noexit("RLEViewer", fileName, "rb");

    if (rle_dflt_hdr.rle_file == NULL) {
	NXRunAlertPanel("RLE ERROR", "Can't open %s", NULL, NULL, NULL, fileName);
	return(self);
    }


    //Read in the header from the RLE file
    if(rle_get_setup(&rle_dflt_hdr) != RLE_SUCCESS){
	NXRunAlertPanel("RLE ERROR", "%s Not an RLE file ", NULL, NULL, NULL, fileName);
	return(self);

    }

    // We don't want to look at the Alpha Channel 
    RLE_CLR_BIT(rle_dflt_hdr, RLE_ALPHA);

    xsize = rle_dflt_hdr.xmax - rle_dflt_hdr.xmin + 1;
    ysize = rle_dflt_hdr.ymax - rle_dflt_hdr.ymin + 1;

    rle_dflt_hdr.xmax -= rle_dflt_hdr.xmin;
    rle_dflt_hdr.xmin = 0;

    if ( rle_dflt_hdr.ncolors != 3){
	NXRunAlertPanel("RLE Warning","Picture has less than 3 colors, will pretend that 3 are present",NULL,NULL,NULL);
        rle_dflt_hdr.ncolors = 3;
    }

    if (rle_row_alloc(&rle_dflt_hdr,&scan) < 0){
	NXRunAlertPanel("RLE ERROR", "%s Malloc Error ", NULL, NULL, NULL, fileName);
	return(self);
    }

    r = (unsigned char *)NXZoneMalloc(newZone,ysize*xsize*(sizeof(unsigned char)));
    g = (unsigned char *)NXZoneMalloc(newZone,ysize*xsize*(sizeof(unsigned char)));
    b = (unsigned char *)NXZoneMalloc(newZone,ysize*xsize*(sizeof(unsigned char)));

    // Read each scan line into memory ready for displaying. 
    for (i = 0; i < ysize; i++) {

	rle_getrow(&rle_dflt_hdr, scan);
	j = i*xsize;
	row_pos = 0;

	while(j <= (i*xsize)+xsize){   // Copy each scanline into a temp
	    r[j]=scan[0][row_pos];     // dataspace
	    g[j]=scan[1][row_pos];
	    b[j]=scan[2][row_pos];
	    j++;
	    row_pos++;
	  }
    }

    // Program WILL DIE if you have a file with a valid rle header but
    // nothing for it to read, it will read the NOTHING in but when you
    // try to render it, the program will die.
    
    rle_row_free(&rle_dflt_hdr,scan);
    fclose(rle_dflt_hdr.rle_file);
    NXSetRect(&temprect, 150.0, (800.0 - (double)ysize),(double)xsize, (double)ysize);

    thiswindow = [Window
		  newContent:&temprect
		  style:NX_TITLEDSTYLE
		  backing:NX_RETAINED
		  buttonMask:NX_CLOSEBUTTONMASK | NX_MINIATURIZEBUTTONMASK | NX_RESIZEBUTTONMASK
		  defer:NO];
    [thiswindow setTitleAsFilename:fileName];
    [thiswindow orderFront:nil];
    [thiswindow display];
    NXPing();

    rmap = r;
    gmap = g;
    bmap = b;

    [[thiswindow setContentView:self] free];
    [thiswindow display];
    return(self);
}

- drawSelf:(const NXRect *)rects :(int)rectCount
{
    if (rmap == 0)         // Check if there is anything to display if there isn't
	return self;       // just return

    [self getFrame:&temprect];
    temprect.origin.x = 0.0;
    temprect.origin.y = 0.0;
    [self lockFocus];
    NXImageBitmap(&temprect, xsize, ysize, 8, 3, NX_PLANAR, NX_COLORMASK, rmap, gmap, bmap, 0, 0);
    [self unlockFocus];
    return self;
}

- free
{
    NXDestroyZone(newZone);
    [super free];
    return(self);
}

-(BOOL)isFlipped       // The RLE image is flipped so let the View instance 
{
    return(YES);

}
@end
