/*****************************************************************************/
/* ActivateMenu.h							     */
/* interface file of ActivateMenu class of ViewGif2 application		     */
/* January 1990  Carl F. Sutter						     */
/*****************************************************************************/

#import <objc/Object.h>
#import <appkit/Menu.h>
#import <appkit/Window.h>
#import <objc/List.h>
#import "Animator.h"

@interface ActivateMenu:Object
   {
   // outlets
   id		slideshowPanel;			// connect to slideshow panel
   id		period;				// connect to Form for timing
   
   // internal instance variables
   Menu 	*activateMenu;			// activate menu
   List		*winList;			// list of window handles
   Animator	*timer;				// Instance of Animator object
   int		nCurrentWindow;			// current window # in slide show
   }

// factory method
+ new;

// outlet initialization methods
- setSlideshowPanel:anObject;
- setPeriod:anObject;

// close message maybe sent from document windows
- windowWillClose:(Window *)winRemove;

// actions
- addDocument:(Window *)winAdd;
- removeDocument:(Window *)winRemove;
- start_stop:sender;
- show:sender;

// internal methods
- (BOOL)findActivateMenu;
- activateDocument:sender;
- nextSlide:sender;

@end
