/*****************************************************************************/
/* Controller.h								     */
/* interface file of Controller class of ViewGif2 application		     */
/* January 1990  Carl F. Sutter						     */
/*****************************************************************************/

#import <objc/Object.h>
#import <appkit/Bitmap.h>
#import "FileQueue.h"
#import "DecodeGIF.h"
#import "ActivateMenu.h"

@interface Controller:Object
   {
   FileQueue	*Queue;			/* file queue IB Module instance */
   DecodeGIF	*Decoder;		/* decoder IB Module instance */
   ActivateMenu	*activateMenu;		/* activate menu IB module (&slideshow) */
   char		szCurrentFile[160];	/* filename currently being processed */
   }

// factory method
+ new;

// App delegate messages
- (BOOL)appAcceptsAnotherFile:sender;
- (int)appOpenFile:(const char *)filename type:(const char *)aType;

// actions
- showQueue:sender;
- showDecoder:sender;
- showSlideshow:sender;
- openRequest:sender;
- saveToTiff:sender;
- printRequest:sender;
- pageLayout:sender;

// internal
- nextFromQueue:(char *)szFileName;
- decoderDone:(Bitmap *)bmpImage;
- (NXPoint)nextTopLeft;
- errorAlert:(char *)szMessage;

@end
