/*
 * common.h
 *
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 * $Id$
 *
 * $Log$
 */
#ifndef COMMON_H 
#define COMMON_H

#include <stdio.h>
#include <math.h>
#include "config.h"

typedef double Float;

#if (VOIDFLAGS & 8) == 8
typedef void * voidstar;
#else
typedef char * voidstar;
#endif

#include "vector.h"
#include "ray.h"
#include "color.h"
#include "transform.h"
#include "error.h"

#define TRUE		1
#define FALSE		0

/*
 * Various useful constants and macros.
 */
#define	PI		3.14159265358979323846
#define TWOPI		(2. * PI)
#define INV_TWOPI	(1. / TWOPI)
#define deg2rad(x)	(Float)(x * PI/180.)
#define LNHALF		(-.69314718)

#ifndef NULL
#	define NULL 0
#endif

#define UNSET		-1

/*
 * Some systems, such as the RS6000, have fast fabs already defined.
 */
#ifndef fabs
extern Float RSabstmp;
#define fabs(x) 		((RSabstmp=x) < 0 ? -RSabstmp : RSabstmp)
#endif

#ifdef MULTIMAX
/*
 * On the multimax, allocate large pieces of memory as shared memory.
 */
extern char *share_malloc(), *share_calloc();
#else
/*
 * Otherwise, malloc is malloc, etc.
 */
#define share_malloc(x)		Malloc(x)
#define share_calloc(x,y)	Calloc(x,y)
#endif

/*
 * Return a uniformly distributed random variable between -s/2 and s/2.
 */
#define jitter(s)		((NRAND() * (s)) - (s)*0.5)
/*
 * Close enough for us.
 */
#define equal(a, b)		(fabs((a) - (b)) < 0.000001)
/*
 * Maximum/Minimum functions
 */
#define max(a, b)		((a) > (b) ? (a) : (b))
#define min(a, b)		((a) < (b) ? (a) : (b))

extern voidstar Malloc(), Calloc();
extern char	*strsave();
extern double	drand48();	/* just in case */

#endif /* COMMON_H */
