case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . config.sh
    ;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting Makefile (with variable substitutions)"
: This section of the file will have variable substitutions done on it.
: Move anything that needs config subs from !NO!SUBS! section to !GROK!THIS!.
: Protect any dollar signs and backticks that you do not want interpreted
: by putting a backslash in front.  You may delete these comments.
$spitshell >Makefile <<!GROK!THIS!
#
# Makefile for rayshade.
#
# Craig Kolb
#
# \$Id: Makefile,v 3.0.1.1 90/03/07 21:38:06 craig Exp \$
#
# Bin directory
#
BINDIR = $bin 
#
# If you are using LINDA, add -DLINDA
# If you are running on a Multimax, add -DMULTIMAX -DSHAREDMEM
# Be sure to add any necessary floating point hardware switches.
# 
OPTIMIZE = $optimize
URTINC = $urtinc
CCFLAGS = $ccflags $large
URTLIB = $urtlib
LDFLAGS = $libs $ldflags
CC = $cc
MKDEP = $mkdep
YACC = $yacc

!GROK!THIS!

: In the following dollars and backticks do not need the extra backslash.
$spitshell >>Makefile <<'!NO!SUBS!'
INCLUDE = -I..
YFLAGS = -d

LIBCOMMON = ../libcommon/libcommon.a
LIBIMAGE = ../libimage/libimage.a
LIBLIGHT = ../liblight/liblight.a
LIBOBJ = ../libobj/libobj.a
LIBSURF = ../libsurf/libsurf.a
LIBTEXT = ../libtext/libtext.a

RAYLIBS = $(LIBCOMMON) $(LIBOBJ) $(LIBLIGHT) $(LIBSURF) $(LIBTEXT) $(LIBIMAGE)

CFLAGS = $(CCFLAGS) $(URTINC) $(INCLUDE) $(OPTIMIZE)
SHELL = /bin/sh

#
# If you are using a Multimax, add -lpp
# If you have a fast malloc library, use it (e.g., -lmalloc on MIPS machines)
#
LIBS = $(RAYLIBS) $(URTLIB) $(LDFLAGS)

# Linda compiler, if appropriate.
#
#LCC = /homes/systems/carriero/linda/v2.2/bin/clc
#
# Change "raytrace.o" to "raytrace.lo" below if using Linda.
#

SUPPORT_C =	misc.c options.c lightdef.c objdef.c stats.c surfdef.c \
		version.c

SUPPORT_H =	../config.h datatypes.h funcdefs.h \
		../patchlevel.h rayshade.h

PARSE_C =	yacc.c lex.c

DRIVE_C =	main.c setup.c viewing.c raytrace.c shade.c picture.c

DRIVE_H =	y.tab.h defaults.h viewing.h raytrace.h picture.h

SUPPORT_O = $(SUPPORT_C:.c=.o)

PARSE_O = $(PARSE_C:.c=.o)

DRIVE_O = $(DRIVE_C:.c=.o)

HFILES = $(DRIVE_H) $(SUPPORT_H)

CFILES = $(DRIVE_C) $(PARSE_C) $(SUPPORT_C)

SHFILES = Makefile.SH

OBJ = $(DRIVE_O) $(PARSE_O) $(SUPPORT_O)

DEPENDSRC = $(DRIVE_C) lex.l yacc.y $(SUPPORT_C)

#
# Change $(CC) below to $(LCC) if using Linda.
#
rayshade: $(OBJ) $(RAYLIBS)
	$(CC) $(OPTIMIZE) -o rayshade $(OBJ) $(RAYLIBS) $(LIBS)

#
# Uncomment the following rule if using Linda.
#
#raytrace.lo: raytrace.cl
#	$(LCC) $(CFLAGS) -c raytrace.cl

#
# End of configuration section
#
install:	rayshade
		mv rayshade $(BINDIR)/rayshade

clean:
	rm -f $(OBJ) core

realclean:
	rm -f $(OBJ) core y.tab.h
	rm -f *.orig Makefile

lint:
	lint $(CFLAGS) -x $(CFILES) -lm

tags:
	ctags -t $(CFILES)

depend:
	(sed '/^# DO NOT DELETE THIS LINE/q' Makefile && \
	 $(MKDEP) $(DEPENDSRC) | sed 's/: \.\//: /; /\/usr\/include/d' \
	) >Makefile.new
	cp Makefile Makefile.bak
	cp Makefile.new Makefile
	rm -f Makefile.new


# DO NOT DELETE THIS LINE
!NO!SUBS!
chmod 755 Makefile
$eunicefix Makefile
