/* A date class based on the routines in COMPUTER LANGAUGE V7, No12, 1990
	page 57-62 */

#import <objc/Object.h>

typedef long JulianDate;
typedef short WeekDay;
typedef short Day;
typedef short Month;
typedef short Year;

@interface Date : Object
{
	char *dateString;		// A date string in the form day/month/year
	JulianDate date;		// The Julian day number
	// The corresponding integer values
	Day day;
	Month month;
	Year year;
	// The 24 hour time
	short hours;
	short minutes;
	short seconds;
	char errorMode;		// The error mode flag
}

/* Actions */

/* Class methods */
+ (const char *) selName : (SEL) theSEL;

/* initialization methods */
- initFromString : (char *) theDate;
- initFromDate : (Day) d : (Month) m : (Year) y;
- initFromJulianDate : (JulianDate) jDate;
- initFromNow;
- setTime : (short) hr : (short) min : (short) sec;
- free;

/* Set whether an invalid date will either
	1) Simply return a nil object: mode = 0 (this is the default)
	2) Display an alert panel and then return nil: mode = 1
	3) Display an alert panel and allow the user to correct the date: mode = 2
*/
- setErrorMode : (int) mode;

/* Conversion functions */
// Returns the calendar date of jDate
- calendarDate : (JulianDate) jDate : (Day *) d : (Month *) m : (Year *) y;
- (JulianDate) julianRep : (Day) d : (Month) m : (Year) y;  // Returns the Julian rep for the calendar date
- (JulianDate) julianDate;		// Returns the date in its Julian representation
- (Day) day;					// Returns the day of the month
- (Month) month;				// Returns the month [0-11]
- (Year) year;				// Returns the year
- (short) hours;				// Returns the hours
- (short) minutes;				// Returns the minutes
- (short) seconds;			// Returns the seconds
- (void) time : (short *) hr : (short *) min : (short *) sec;  // Set to the objects time
- (const char *) stringDate;		// Returns the date in the form "m/d/yyyy"
- (const char *) stringFixedDate;	// Returns the date in the form "mm/dd/yyyy"
- (const char *) fullStringDate;		// Returns the date in the form "DayOfWeek Month dd Year"
- (const char *) time24hr;			// Returns the time string "hh:mm"
- (const char *) timeAM_PM;		// Returns the time string "h[h]:mm [AP]m" where h <= 12
- (WeekDay) weekDay;		// Returns the day of the week Sun-Sat [0-6]
- (int) weekOfYear;			// Returns the week number of the year [0-51]

/* System time access */
// Set the componets to those returned by localtime(3)
- (void) now : (Day *) d : (Month *) m : (Year *) y : (short *) hr : (short *) min : (short *) sec;
// Return the system clock time(3)
- (long) sysTime;

/* Ouput */
- (void) print;

/* Private methods to check the date and report errors */
- (BOOL) validDate;
- invalidDate : (SEL) callingMethod;
/* Method invoked by the Ok button of the editErrorPanel */
- dateOk : sender;
/* Method invoked by the ``Return nil'' button of the editErrorPanel */
- dateCancel : sender;

@end
/* RCS Information:
	$Author: me $;
	$Date: 92/05/03 17:24:52 $;
	$Source: /RS6000/usr/local/NFS_NeXT/Dev/Net/Archie_Prospero/Archie/RCS/Date.h,v $;
	$Revision: 1.4 $;
*/
