/***************************************************************************/
/* MovingBitmap.h - interface file for MovingBitmap class                  */
/* January 1990 Carl F. Sutter							   */
/***************************************************************************/

#import <objc/Object.h>
#import <appkit/Bitmap.h>

@interface MovingBitmap:Object
   {
   Bitmap	*bmpPiece;			// bitmap to hold image of piece
   float	flXPos, flYPos;		// next postion of piece
   float	flOldXPos, flOldYPos;	// last piece position for erasing
   float	flXVel, flYVel;		// velocity vector of bitmap in units/move
   NXRect	nxrLimits;			// limits of frame that this bitmap exists in
   NXSize	nxsPiece;			// size of bitmap
   }

/* factory method */
+ newFromMachO:(const char *)tiffFile inFrame:(NXRect *)limits;

/* actions */
- setFrame:(NXRect *)nxrFrame;
- setPosition:(float)xPos :(float)yPos;
- setVelocity:(float)xVel :(float)yVel;
- move;
- erase;
- draw;

@end
