#import "FlashApp.h"
#import "FlashDocument.h"
#import "Card.h"
#import <appkit/defaults.h>
#import <appkit/nextstd.h>
#import <appkit/PrintInfo.h>
#import <appkit/Control.h>
#import <appkit/Font.h>

@implementation FlashApp
/*
 * This dervative of AppWithDoc contains Defaults and Creation class methods,
 * as well as the global Search field.
 * The superclass handles all new/open/terminate methods, as well as Activate.
 */

/* Class  methods */

+ initialize
/*
 * Initializes the defaults.
 */
{
	const NXDefaultsVector FlashDefaults = {
		{"KeyFont", "Times-Italic"}, {"KeyFontSize", "18"},
		{"ResFont", "Times-Roman"}, {"ResFontSize", "16"},
		{ "Quit", NULL }, { NULL, NULL }    };
	NXRegisterDefaults(appName, FlashDefaults);
	return self;
}

+ new
/*
 * Set the printInfo for the entire application.  Hard-wired.
 */
{
	self = [super newClass:[FlashDocument class] 
	      extension:"flash" version:FLASH_VERSION];
	[[[NXApp printInfo] setPagesPerSheet:2]
		setMarginLeft:32.0 right:32.0 top:32.0 bottom:32.0];	
	return self;
}

/* General application status and information querying/modifying methods. */
- defaultFont:(STR)name
{
	char *buffer;
	id font;

	NX_MALLOC(buffer,char, strlen(name)+5);
	strcpy(buffer, name);
	strcat(buffer,"Size");
	font = [Font newFont:NXGetDefaultValue(appName, name)
			size:atof(NXGetDefaultValue(appName, buffer))];
	NX_FREE(buffer);
	return font;
}

- setSearchField:sender
/*
 * Set whether the Key or Response field is being searched on
 * from the Find Panel
 */
{
	[Card setActiveFace:[sender selectedTag]];
	return self;
}

@end

