#import <Document.h>

@interface FlashDocument : Document
{
    id rand;
    id currentCard;		/* card currently displayed */
    id currentText;		/* first responder, if any */
    BOOL cardNew,cardChanged;		/* Status of last card */
    BOOL viewMode;			/* View or Update Mode */
    id textView[2];			/* the Text Views */
    id reveal;				/* reveal button */
    id diff;				/* difficulty button-matrix */
    id markCount;			/* Show what the marker count is */
}

/* Factory methods */

+ new;
+ newFromFile:(const char *)file;

/* Instance methods */
- getWindow;
- newCard;

- switchViewMode:sender;
- setViewMode:(BOOL)newMode;
- (BOOL)viewMode;
- (BOOL)checkCurrent;

/* Card Display Methods */

- showText;
- showTextOf:aCard;

/* Target/Action methods */

/* Card Display/Update Action Methods */
- reveal:sender;
- cover:sender;
- wasEasy:sender;
- wasFair:sender;
- wasHard:sender;

- next:sender;
- add:sender;
- modify:sender;
- delete:sender;

/* Deck manipulation Action methods */
- doAct:(SEL)action for:(STR)name;
 
- previous:sender;
- find:sender;
- shuffle:sender;
- sort:sender;
- swapFields:sender;
- reset:sender;

/* File Action Methods */

- print:sender;
- save:sender;
- revertToSaved:sender;

/* Window & Text delegate methods */

- (BOOL)textWillChange:sender;
- (BOOL)textWillEnd:sender;

/* Text editing methods */

- centerText:sender;
- leftJustifyText:sender;
- rightJustifyText:sender;

@end

