// Copyright (C) 1989 Jacob Gore
// 
// This file is part of GNULicense, a package to ease the inclusion
// of the GNU General Public License into NextStep applications.
// 
//     This program is free software; you can redistribute it and/or modify
//     it under the terms of the GNU General Public License as published by
//     the Free Software Foundation; either version 1, or (at your option)
//     any later version.
// 
//     This program is distributed in the hope that it will be useful,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//     GNU General Public License for more details.
// 
//     You should have received a copy of the GNU General Public License
//     along with this program; if not, write to the Free Software
//     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
//     or send electronic mail to Jacob Gore <jacob@gore.com>.

// The code to print the License leaves much to be desired.  I have left my
// most successful attempts at providing the user with the printing interface
// that is supposed to be the norm on the NeXT (put up a PrintPanel, etc.) in
// this file, commented out.  If anybody can do it right, please send me the
// code!
//
// Jacob Gore <jacob@gore.com>
/*---------------------------------------------------------------------------
April, 1990
This source code has been locally modified.  The initial modifications are
summarized below.  Future modifications will appear in the RCS log entries.

Source modifications
  April 1, 1990 (Rex Pruess)
    o Removed all code associated with printing.  Users can cut/paste if
      they desire to print the license.
    o Changed load to use "withNames:NO" for minor performance gain.
    o Changed "panel" to "gnuPanel".
---------------------------------------------------------------------------
Rex Pruess  <rpruess@umaxc.weeg.uiowa.edu>

$Header: /rpruess/apps/Remotes/RCS/GNULicense.m,v 1.1 90/04/10 14:20:32 rpruess Exp $
-----------------------------------------------------------------------------
$Log:	GNULicense.m,v $
Revision 1.1  90/04/10  14:20:32  rpruess
Initial revision

-----------------------------------------------------------------------------*/

/* GNULicense class header file */
#import "GNULicense.h"

/* Appkit header files */
#import <appkit/Application.h>
#import <appkit/Panel.h>

@implementation GNULicense

+ new
{
    self = [super new];
    [NXApp loadNibSection:"GNULicense.nib" owner:self withNames:NO];
    [gnuPanel setMiniwindowIcon:"app"];
    return self;
}

- showLicense:sender
{
    [gnuPanel makeKeyAndOrderFront:sender];
    return self;
}

- setGnuPanel:anObject
{
    gnuPanel = anObject;
    return self;
}

@end
