
/* Generated by Interface Builder */

#import "MrDelegate.h"

#define NUMCELLS 25


@implementation MrDelegate

//  This method takes care of loading the browser.
//  Normally, you might do this when the window is brought on the screen,
//  or perhaps, when your front window changes.
//  To "jumpstart" the browser, we load the very first column.
//  Remember that when your application object calls it's delegate with this method
//  That all your instance variables have been set.

-appDidInit:sender;
{
	printf("appDidInit\n");
	[theBrowser loadColumnZero];
	return self;
}

// This is the method that is called when the browser needs to be filled.
// Since what we put is based on the coulmn number, we need a special case for
// column zero.
// in you code, you would probalby search through a data structure, to find the proper value
// to display in each cell of each column.

/* Items of Note:
		before we fill the matrix, we have to know how many items are in the matrix
		We must set seach cell.
		We must determine if each cell is a leaf or branch.
		we must return the number of cells in the column
		Collumn zero is always the same.
		columns 1.. are based on the items clicked in the previous column,
			There fore we must look at the previous column to figure out
			what to display.
		This method is called BEFORE, the target is told of the click.
*/

- (int)browser:sender fillMatrix:matrix inColumn:(int)column;
{
	int i;
	int multiplier;

	printf("browser:<id> fillMatrix:<id> inColumn: %d\n",column);
	if (column==0) {
		[matrix renewRows:NUMCELLS cols:1];
		for (i=0 ; i< NUMCELLS; i++) {
			[[matrix cellAt:i :0] setIntValue:i];
			[[matrix cellAt:i :0] setLeaf:NO];
		}
		return NUMCELLS;
	} else {
		[matrix renewRows:NUMCELLS cols:1];
		
					// we need to figure out what the multiplier is.
					// We do this by finding the selected cell in the previous column.
					// You would probably want the stringValue instead.  There are					// very few uses for numerical browsers.
					
		multiplier = [[[sender matrixInColumn:column-1] selectedCell] intValue];
		for (i=0 ; i< NUMCELLS; i++) {
			[[matrix cellAt:i :0] setIntValue:i*multiplier];
			[[matrix cellAt:i :0] setLeaf:NO];
		}
		return NUMCELLS;
	}
	return 0;
}
@end
