#import <appkit/appkit.h>
#import "ConferenceListener.h"
#import <mach.h>
#import <sys/message.h>
#import <servers/netname.h>
extern port_t name_server_port;
extern id NXResponsibleDelegate();
@implementation  ConferenceListener :Listener
{}
static NXRemoteMethod *remoteMethods = NULL;
#define REMOTEMETHODS 3
+ (void)initialize 
/* */
{
    if (!remoteMethods) {
	remoteMethods =
	(NXRemoteMethod *) malloc((REMOTEMETHODS+1)*sizeof(NXRemoteMethod));
	remoteMethods[0].key = 
	@selector(helloIAm:length:);
	remoteMethods[0].types = "b";
	remoteMethods[1].key = 
	@selector(goodByeIAmLeaving:length:);
	remoteMethods[1].types = "b";
	remoteMethods[2].key = 
	@selector(sendMessage:from:length:);
	remoteMethods[2].types = "cb";
	remoteMethods[REMOTEMETHODS].key = NULL;
    }
}
-(int)helloIAm : (char *) fr
	length : (int) len
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(helloIAm:length:)))
	return [_NXd helloIAm : fr
		length : len];
    return -1;
}

-(int)goodByeIAmLeaving : (char *) fr
	length : (int) len
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(goodByeIAmLeaving:length:)))
	return [_NXd goodByeIAmLeaving : fr
		length : len];
    return -1;
}

-(int)sendMessage : (char *) msg
	from : (char *) fr
	length : (int) len
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(sendMessage:from:length:)))
	return [_NXd sendMessage : msg
		from : fr
		length : len];
    return -1;
}

- (int) performRemoteMethod : (NXRemoteMethod *) method
                  paramList : (NXParamValue *) paramList {
/* */
    switch (method - remoteMethods) {
    case 0:
	return [self helloIAm : paramList[0].bval.p
		length : paramList[0].bval.len];
    case 1:
	return [self goodByeIAmLeaving : paramList[0].bval.p
		length : paramList[0].bval.len];
    case 2:
	return [self sendMessage : paramList[0].bval.p
		from : paramList[1].bval.p
		length : paramList[1].bval.len];
    default:
	return [super performRemoteMethod : method paramList : paramList];
    }
}
- (NXRemoteMethod *) remoteMethodFor: (SEL) aSel {
/* */
    NXRemoteMethod *rm;
    if (rm = NXRemoteMethodFromSel(aSel,remoteMethods))
        return rm;
    return [super remoteMethodFor : aSel];
}
@end
