/*--------------------------------------------------------------------*/
/*                                                                    */
/*                         DISCLAIMER NOTICE                          */
/*                                                                    */
/* This document and/or  portions of the material  and data furnished */
/* herewith, was developed under sponsorship of the U.S.  Government. */
/* Neither the  U.S.  nor  the U.S.D.O.E.,   nor the  Leland Stanford */
/* Junior  University,  nor  their employees,   nor their  respective */
/* contractors,   subcontractors,   or their  employees,   makes  any */
/* warranty,   express  or  implied,  or  assumes  any  liability  or */
/* responsibility for  accuracy,  completeness  or usefulness  of any */
/* information,   apparatus,   product  or   process  disclosed,   or */
/* represents that its use will  not infringe privately-owned rights. */
/* Mention of any product, its manufacturer,  or suppliers shall not, */
/* nor is it intended to, imply approval, disapproval, or fitness for */
/* any particular  use.   The U.S.  and  the University at  all times */
/* retain  the right  to use  and  disseminate same  for any  purpose */
/* whatsoever.                                                        */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*                                                                    */
/* Copyright (C)  1989  The Board of Trustees of  The Leland Stanford */
/* Junior University.  All Rights Reserved.                           */
/*                                                                    */
/*--------------------------------------------------------------------*/
/* Written by Paul Kunz, pfkeb@ebnextk.slac.stanford.edu			  */

#import "Defaults.h"

#import <appkit/Application.h>
#import <appkit/defaults.h>
#import <appkit/Form.h>
#import <appkit/Panel.h>

@implementation Defaults

- setTerminalPanel:anObject
{
    terminalPanel = anObject;
    return self;
}

- setTerminalForm:anObject
{
    terminalForm = anObject;
    return self;
}

- setShellPanel:anObject
{
    shellPanel = anObject;
    return self;
}

- setShellForm:anObject
{
    shellForm = anObject;
    return self;
}

- menuTerminal:sender
{
	static char *parameter[11] = {
		"Lines", "Columns", "NXFixedPitchFont", "NXFixedPitchFontSize", "Console",
		"Shell", "SourceDotLogin", "WinLocX", "WinLocY", "NXMenuX", "NXMenuY"
	};
	static char *terminalApp = "Terminal";
	theApp = terminalApp;
	thePanel = terminalPanel;
	aForm = terminalForm;
	theParms = parameter;
	[self getDefaults];
    return self;
}

- menuShell:sender
{
	static char *parameter[9] = {
		"HeightInChars", "WidthInChars", "NXFixedPitchFont", "NXFixedPitchFontSize",
		"Console", "SourceDotLogin", "NXMenuX", "NXMenuY"
	};
	static char *shellApp = "Shell";
	theApp = shellApp;
	thePanel = shellPanel;
	aForm = shellForm;
	theParms = parameter;
	[self getDefaults];
    return self;
}

- getDefaults
{
	const char *astring;
	int             i, nrows, ncols;
	[thePanel makeKeyAndOrderFront:self];
	[aForm getNumRows:&nrows numCols: &ncols];
	for (i = 0; i < nrows; i++) {
		astring = NXReadDefault(theApp,theParms[i]);
		[aForm setStringValue:astring at :i];
	}
	return self;
}

- ok:sender
{
	const char *astring;
	int             i, nrows, ncols;
	[aForm getNumRows:&nrows numCols: &ncols];
	for (i = 0; i < nrows; i++ ) {
		astring = [aForm stringValueAt:i];
		if ( astring == NULL )
			continue;
		if ( *astring != '\0' ) 
			NXWriteDefault(theApp, theParms[i], astring);
	}
	[thePanel orderOut:self];
	return self;
}	

- cancel:sender
{
	[thePanel orderOut:self];
	return self;
}

@end
