/* Program:
 *
 *		MOTD - 'Motto of the day' window
 *
 * Author:
 *
 *		Christopher Lane (lane@sumex-aim.stanford.edu)
 *		Symbolic Systems Resources Group
 *		Knowledge Systems Laboratory
 *		Stanford University
 *
 * Contributors:
 *
 *		Izumi Ohzawa (izumi@violet.berkeley.edu)
 *		Group in Neurobiology/School of Optometry
 *		University of California, Berkeley
 *
 *		Steve Hayman (sahayman@cs.indiana.edu)
 *		Computer Science Department Workstation Manager
 *
 * Date:
 *
 *		9 January 1991
 *
 * Copyright:
 *
 *		1989, 1990 & 1991 by The Leland Stanford Junior University.
 *      May be distributed without restriction for non-commercial use.
 *
 */

#import "MOTD.h"

void timer(DPSTimedEntry teNumber, double now, id self)
{
	static int seconds = -1; 
	static char string[] = "Hold (000)";
    
	if (seconds == -1) seconds = [self getWait];

	if ([self getHold] == NO) {
		if (seconds-- <= 0) [self terminate:self];
		else if ([self getDo_Motd]) {
			(void) sprintf(string, "Hold (%3d)", seconds);
			[[self getHoldButton] setTitle:string];
			}
		}
}

void main(int argc, char *argv[])
{
	FILE *f_utmp;
	struct stat s_stat;
	struct utmp s_utmp;
	struct passwd *p_passwd;
	BOOL flag, do_motdL = YES;
	MailLevel maillevelL = NONE;
	char pathnamebuf[MAXPATHLEN];

	NXApp = [MOTD new];
    
	if (!(flag = (--argc && (p_passwd = getpwnam(argv[argc])) != NULL))) p_passwd = getpwuid((int) getuid());

	[[[NXApp setLoginHook:flag] setMailLevel:maillevelL] setDo_Motd:do_motdL];

	if (p_passwd != NULL) {
		[[NXApp setUserName:p_passwd->pw_name] setUID:p_passwd->pw_uid];
		
		if (flag) { /* only check if LoginHook */
			(void) strcpy(pathnamebuf, MAILDIR); /* check for mail arrival */
			(void) strcat(pathnamebuf, [NXApp getUserName]);
			if (stat(pathnamebuf, &s_stat) != CERROR && s_stat.st_size != 0)
			[NXApp setMailLevel:(maillevelL = (s_stat.st_atime <= s_stat.st_mtime) ? NEW : OLD)];
			}

		if (strncmp(getDefault("OnlyOnce"), "Yes", 1) == EQ &&
			stat([NXApp getFile], &s_stat) != CERROR && (f_utmp = fopen(WTMPFILE, "r")) != NULL) {
			while(fread(&s_utmp, sizeof(s_utmp), 1, f_utmp))
				if (s_stat.st_mtime < s_utmp.ut_time &&
					strncmp(s_utmp.ut_name, [NXApp getUserName], sizeof(s_utmp.ut_name)) == EQ)
					if ((flag && strncmp(s_utmp.ut_line, TTYDEVICE, sizeof(s_utmp.ut_line)) == EQ) ||
						(strncmp(s_utmp.ut_line, FTPPREFIX, sizeof(s_utmp.ut_line)) != EQ)) {
						[NXApp setDo_Motd:(do_motdL = NO)];
						break; /* while() */
						}
			(void) fclose(f_utmp);
			}
		}

	if (do_motdL || maillevelL != NONE) { /* if motd file not seen yet OR if there is mail */
		[NXApp loadNibSection:"MOTD.nib" owner:NXApp];
		if (do_motdL) [[NXApp getCancelButton] setEnabled:flag];    
		[[NXApp run] free];
		}
	else [NXApp free];
	exit(EXIT_SUCCESS);	
}