/* Controller.m -- Controller object for MailHelper application.
   Copyright 1991, Izumi Ohzawa, All rights reserved.
   3-17-91  Starting project.
   Some codes are borrowed from AtYourService NeXT demo application.
   4-6-91   Bug fix: fclose(fpin); was missing in method insertSignature.
*/


#import "Controller.h"
#import <appkit/Application.h>
#import <appkit/Panel.h>
#import <appkit/Listener.h>
#import <appkit/ScrollView.h>
#import <appkit/Text.h>
#import <appkit/Pasteboard.h>
#import <stdlib.h>
#import <strings.h>
#import <mach_init.h>
#import <vm/vm_user.h>
#import <sys/stat.h>


@implementation Controller

- appDidInit:sender
{
	myListener = [NXApp appListener];
	[myListener setServicesDelegate: self];
	return self;
}

/* Brings up the Info panel.   Not done on startup because it's in a separate
 * interface file. Saves startup time for the user if we do this when they ask
 * for it, and not before.
 * "infoPanel" and "helpPanel" are defined in "Info.nib".
 */
- infoPanel:sender
{
    if( ! infoPanel ){
        [NXApp loadNibSection:"Info.nib" owner:self];
    }
    [infoPanel makeKeyAndOrderFront:sender];
    return self;    
}

/*
 * Brings up the Help panel (as above)
 */
- helpPanel:sender
{
    if( ! helpPanel ){
        [NXApp loadNibSection:"Info.nib" owner:self];
    }
    [helpPanel makeKeyAndOrderFront:sender];
    return self;    

}



// Reformats selected text so that it fits into a specified column width.

- reformatSelection:(id)pbid userData:(const char *)udata error:(char **)errmsg
{
char *data; 
int   length;
const char *const *types;
int   hasAscii, i;
int   column=1, nextcolumn=1, colLimit=TEXTWIDTH;

	types = [pbid types];		/* get a list of pasteboard types */
	hasAscii = 0;
	for(i=0; !hasAscii && types[i]; i++)
	    if(!strcmp(types[i], NXAsciiPboardType)) hasAscii = 1;
	if(hasAscii)
	{
	    [pbid readType:NXAsciiPboardType data:&data length:&length];
	    if(data && length)
	    {
                char *returnData, *dataptr, *endptr;
		char *wordptr, *nextwordptr;
            
                returnData=malloc(length+3);
                dataptr = strncpy(returnData, data, length);
		wordptr = nextwordptr = dataptr;
		endptr = dataptr+length;
                for (i=1;i<=length;i++)   /* remove all line breaks execpt doubles */
		{
		    if(*dataptr == '\n' && *(dataptr+1) == '\n')
		    {
			dataptr += 2;
			continue;
		    }
		    else if(*dataptr == '\n')
		    	*dataptr = ' ';	    
                    dataptr++;
		}

		column = nextcolumn = 1;
		while(nextwordptr < endptr)
		{
		    while(wordptr < endptr && *wordptr != ' ' && *wordptr != '\n')
		    {
			wordptr++;
			column++;
		    }
		    /* on exit from above while(), wordptr should still be at ' ' or '\n' */
		    if(*wordptr++ == '\n')
		    {
		        column = nextcolumn = 1;
			continue;
		    }    
		    nextwordptr = wordptr;
		    nextcolumn = column;
		    while(nextwordptr < endptr && *nextwordptr != ' ' && *nextwordptr != '\n')
		    {
		    	nextwordptr++;
			nextcolumn++;
		    }
		    if(nextcolumn >= colLimit)
		    {
			*(wordptr-1) = '\n';
			column = nextcolumn =1;
		    }
		}
		*endptr= '\n';
		*(endptr+1) = '\0';
            	[pbid declareTypes:&NXAsciiPboardType num:1 owner:self];
            	[pbid writeType:NXAsciiPboardType data:returnData length:strlen(returnData)];
            	free(returnData);
	    } /* end if(data && length) */
	    else
		*errmsg = "Selection is empty.";
	    vm_deallocate(task_self(), data, length);
	}  /* end if(hasAscii) */
	else
	    *errmsg = "No ASCII text found in your selection.";
	return self;
}

// Adds quotation marks "> " to the head of each line of selected text.

- quoteSelection:(id)pbid userData:(const char *)udata error:(char **)errmsg
{
char *data; 
int   length;
const char *const *types;
char *quotestr = QUOTESTRING;
int   hasAscii, i, quotelen;

	quotelen = strlen(quotestr);
	types = [pbid types];		/* get a list of pasteboard types */
	hasAscii = 0;
	for(i=0; !hasAscii && types[i]; i++)
	    if(!strcmp(types[i], NXAsciiPboardType)) hasAscii = 1;
	if(hasAscii)
	{
	    [pbid readType:NXAsciiPboardType data:&data length:&length];
	    if(data && length)
	    {
                int numlines;
		char ch;
                char *returnData, *dataptr, *endptr, *outptr;

		numlines = 1;
		dataptr = data;		  /* ptr to original data */
		endptr = data+length;	  /* ptr to end of data */
		while(dataptr < endptr)   /* count the number of lines */
		    if(*dataptr++ == '\n')
			numlines++;
                returnData=malloc(length+numlines*quotelen+3);
		dataptr = data;		  /* reinitialize ptr to orig data */
		outptr = returnData;
		for(i=0;i<quotelen;i++)
		   *outptr++ = quotestr[i];
		while(dataptr < endptr)
		{
		    if((ch = *dataptr++) == '\n')
		    {
			*outptr++ = ch;
		        for(i=0;i<quotelen;i++)
		           *outptr++ = quotestr[i];
		    }
		    else
			*outptr++ = ch;
		}
		*outptr = '\n';
		*(outptr+1) = '\0';
            	[pbid declareTypes:&NXAsciiPboardType num:1 owner:self];
            	[pbid writeType:NXAsciiPboardType data:returnData length:strlen(returnData)];
            	free(returnData);
	    } /* end if(data && length) */
	    else
		*errmsg = "Selection is empty.";
	    vm_deallocate(task_self(), data, length);
	}  /* end if(hasAscii) */
	else
	    *errmsg = "No ASCII text found in your selection.";
	return self;
}


// Adds the content of ~/.signature at the current cursor location.

- insertSignature:(id)pbid userData:(const char *)udata error:(char **)errmsg
{
char *data;
char *signaturefile = SIGFILENAME;
char signaturepath[256];
int length;
struct stat filestat;
FILE *fpin;
    sprintf(signaturepath, "%s/%s", NXHomeDirectory(), signaturefile);
    if(stat(signaturepath, &filestat))
    {
	data = "";
	length = 0;
	*errmsg = "No signature file found in your home directory.";
    }
    else
    {
	length = filestat.st_size;
        if((fpin = fopen(signaturepath, "r")) != NULL)
        {
	    data = malloc(length+2);
	    fread((void *)data, 1, length, fpin);
	    fclose(fpin);		/* This was missing in V1.0 release */
	    *(data+length) = '\0';
            [pbid declareTypes:&NXAsciiPboardType num:1 owner:self];
    	    [pbid writeType:NXAsciiPboardType data:data length:strlen(data)];
	    free(data);
        }
        else
	    *errmsg = "Cannot open signature file.";
    }
    return self;
}

@end
