/*---------------------------------------------------------------------------
Prefs.m -- Copyright (c) 1991 Rex Pruess

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or send
   electronic mail to the the author.

This routine loads & displays the preferences window.  It also contains the
methods for handling the user requests generated from within the preferences
window.

Rex Pruess <rpruess@umaxc.weeg.uiowa.edu>

$Header: /rpruess/apps/Remotes-2.0/RCS/Prefs.m,v 2.0 91/01/22 15:34:05 rpruess Exp $
-----------------------------------------------------------------------------
$Log:	Prefs.m,v $
Revision 2.0  91/01/22  15:34:05  rpruess
Remotes-2.0 was upgraded for NeXT System Release 2.0 (standard or extended).
Remotes-2.0 supports the NeXT supplied Terminal application and the Stuart
shareware product.

Revision 1.1  90/04/10  14:27:18  rpruess
Initial revision

-----------------------------------------------------------------------------*/

/* Standard C header files */
#include <libc.h>
#include <stdio.h>

/* Prefs class header files */
#import "Prefs.h"
#import "HostListManager.h"

/* Appkit header files */
#import <appkit/Application.h>
#import <appkit/Form.h>
#import <appkit/Matrix.h>
#import <appkit/Window.h>

@implementation Prefs

+ new
{
   self = [super new];
   [NXApp loadNibSection:"Prefs.nib" owner:self withNames:NO];
   [prefsWindow setMiniwindowIcon:"app"];

   return self;
}

/*---------------------------------------------------------------------------
Initialize the fields in the preferences window.
-----------------------------------------------------------------------------*/
- initPrefs:sender
{
   /* Set debugging matrix value. */
   [debugMatrix selectCellWithTag:[theHLM getDebugLevel:self]];
   
   /* Insert config pathname & position cursur to it in the prefs window. */
   [configForm setStringValue:[theHLM getConfigFile:self]];
   [configForm selectTextAt:0];

   return;
}

/*---------------------------------------------------------------------------
The user pressed the menu revert button.
-----------------------------------------------------------------------------*/
- menuRevert:sender
{
   if ([prefsWindow isKeyWindow] == YES)
      [self prefsRevert:self];
   
   return self;
}

/*---------------------------------------------------------------------------
Revert the fields in the preference's window.
-----------------------------------------------------------------------------*/
- prefsRevert:sender
{
   [debugMatrix selectCellWithTag:[theHLM getDebugLevel:sender]];

   [configForm setStringValue:[theHLM getConfigFile:self]];
   [configForm selectTextAt:0];
   return self;
   return self;
}

/*---------------------------------------------------------------------------
Set new values from those specified in the preferences window.
-----------------------------------------------------------------------------*/
- prefsSet:sender
{
   [configForm selectTextAt:0];
   [theHLM setDebugLevel:[[debugMatrix selectedCell] tag]];
   [theHLM setConfigFile:[configForm stringValueAt:0]];
   return self;
}

/*---------------------------------------------------------------------------
Display the preferences window.
-----------------------------------------------------------------------------*/
- showPrefsWindow:sender
{
   [prefsWindow makeKeyAndOrderFront:sender];
   return self;
}

/*---------------------------------------------------------------------------
Establish the outlets.
-----------------------------------------------------------------------------*/
- setConfigForm:anObject
{
   configForm = anObject;
   return self;
}

- setDebugMatrix:anObject
{
   debugMatrix = anObject;
   return self;
}

- setPrefsWindow:anObject
{
   prefsWindow = anObject;
   return self;
}

/*---------------------------------------------------------------------------
Message from Remotes.m results in the execution of this set.
-----------------------------------------------------------------------------*/
- setHLM:anObject
{
   theHLM = anObject;
   return self;
}

@end
