/* File:	Alert.m - (Interactive) Unix shell version of NXRunAlertPanel
 *
 * By:		Christopher Lane (lane@sumex-aim.stanford.edu)
 *
 * Date:	24 July 1990
 *
 * Copyright:	1990 by The Leland Stanford Junior University.
 */

#import <stdlib.h>
#import <appkit/Panel.h>
#import <appkit/Application.h>

//	int NXRunAlertPanel(const char *title, const char *msg, const char *defaultButton,
//		const char *alternateButton, const char *otherButton, ...)

typedef enum {TITLE, MESSAGE, DEFAULT, ALTERNATE, OTHER, ARGC} ARGUMENTS;
typedef enum {ALERTDEFAULT = EXIT_SUCCESS, ALERTALTERNATE, ALERTOTHER, ALERTERROR} RESULTS;

void main(int argc, char *argv[])
{
	int result, context;
	
	context = [(NXApp = [Application new]) activateSelf:YES];
	
	result = NXRunAlertPanel(
		(argc > TITLE) ? argv[TITLE] : NULL,
		(argc > MESSAGE) ? argv[MESSAGE] : NULL,
		(argc > DEFAULT) ? argv[DEFAULT] : NULL,
		(argc > ALTERNATE) ? argv[ALTERNATE] : NULL,
		(argc > OTHER) ? argv[OTHER] : NULL
		);
			
	if (context) (void) [NXApp activate:context];
	[NXApp free];
	
	switch (result) {
		case NX_ALERTDEFAULT: exit(ALERTDEFAULT);
		case NX_ALERTALTERNATE: exit(ALERTALTERNATE);
		case NX_ALERTOTHER: exit(ALERTOTHER);
		}
	exit(ALERTERROR);
}
