/* File:	Open.m - (Interactive) Unix shell version of OpenPanel
 *
 * By:		Christopher Lane (lane@sumex-aim.stanford.edu)
 *
 * Date:	24 July 1990
 *
 * Copyright:	1990 by The Leland Stanford Junior University.
 */

#import <stdlib.h>
#import <getopt.h>
#import <appkit/OpenPanel.h>
#import <appkit/Application.h>

#define USAGE "usage: %s [-f file] [-d directory] [-t type [-t type]] [-p prompt] [-m]\n"
#define EXIT_USAGE (2)

#define MAX_TYPES 64

extern char *fullPath(const char *parent, const char *base); /* <text/pathutil> */

void main(int argc, char *argv[])
{
	OpenPanel *panel;
	const char *const *filenames;
	const char *name = NULL, *path = NULL, *types[MAX_TYPES];
	int context, option, status = EXIT_SUCCESS, ntypes = 0;
	
	context = [(NXApp = [Application new]) activateSelf:YES];
	panel = [OpenPanel new];

	while ((option = getopt(argc, argv, "f:d:t:p:m")) != EOF)
		switch (option) {
		case 'f': name = optarg; break;
		case 'd': path = optarg; break;
		case 't': types[ntypes++] = optarg; break;
		case 'p': [panel setPrompt:optarg]; break;
		case 'm': [panel allowMultipleFiles:YES]; break;
		default : status = EXIT_USAGE;
		}
	if (optind < argc) status = EXIT_USAGE;
	
	types[ntypes] = NULL;
			
	if (status == EXIT_USAGE) (void) fprintf(stderr, USAGE, [NXApp appName]);
	else if ([panel runModalForDirectory:path file:name types:types]) {
		path = [panel directory];
		for (filenames = [panel filenames]; filenames && *filenames; filenames++)
			(void) puts(fullPath(path, *filenames));
		}
	else status = EXIT_FAILURE;
				
	[panel free];
	if (context) (void) [NXApp activate:context];
	[NXApp free];
	
	exit(status);
}
