/* File:	Save.m - (Interactive) Unix shell version of SavePanel
 *
 * By:		Christopher Lane (lane@sumex-aim.stanford.edu)
 *
 * Date:	24 July 1990
 *
 * Copyright:	1990 by The Leland Stanford Junior University.
 */

#import <stdlib.h>
#import <getopt.h>
#import <appkit/SavePanel.h>
#import <appkit/Application.h>

#define USAGE "usage: %s [-f file] [-d directory] [-t type] [-p prompt]\n"
#define EXIT_USAGE (2)

void main(int argc, char *argv[])
{
	SavePanel *panel;
	const char *name = NULL, *path = NULL;
	int context, option, status = EXIT_SUCCESS;
	
	context = [(NXApp = [Application new]) activateSelf:YES];
	panel = [SavePanel new];
	
	while ((option = getopt(argc, argv, "f:d:t:p:")) != EOF)
		switch (option) {
		case 'f': name = optarg; break;
		case 'd': path = optarg; break;
		case 't': [panel setRequiredFileType:optarg]; break;
		case 'p': [panel setPrompt:optarg]; break;
		default : status = EXIT_USAGE;
		}
	if (optind < argc) status = EXIT_USAGE;

	if (status == EXIT_USAGE) (void) fprintf(stderr, USAGE, [NXApp appName]);
	else if ([panel runModalForDirectory:path file:name])
		(void) puts([panel filename]);
	else status = EXIT_FAILURE;
	
	[panel free];
	if (context) (void) [NXApp activate:context];
	[NXApp free];
	
	exit(status);
}
