#import <appkit/Cell.h>
#import <appkit/Form.h>
#import <appkit/Matrix.h>
#import "StateManager.h"
#import "Filter.h"
#import "Script.h"
#import "FilterInspector.h"
#import "ScriptInspector.h"
#import "HelpManager.h"
#import "support.h"

@implementation FilterInspector

- appDidInit: sender
{
	stateManager = sender;
	return self;
}

// passing parameters
- activeChanged
{
	activeFilter = [stateManager activeFilter];
	[filterNameForm setStringValue: [activeFilter filterName] at: 0];
	[commandForm setStringValue: [activeFilter command] at: 0];
	[destinationForm setStringValue: [activeFilter destination] at: 0];
	[inputToggle selectCellWithTag: [activeFilter inputFromStdin]];
	[outputToggle selectCellWithTag: [activeFilter outputToStdout]];
	[menuForm setStringValue: [activeFilter menu] at: 0];
	return self;
}

- (const char *)filterName
{
	const char *p;
	p = [filterNameForm stringValueAt: 0];
	return (p ? p : "");
}
- (const char *)command
{
	const char *p;
	p = [commandForm stringValueAt: 0];
	return (p ? p : "");
}
- (const char *)destination
{
	const char *p;
	p = [destinationForm stringValueAt: 0];
	return (p ? p : "");
}
- (int) inputFromStdin
{
	return [[inputToggle selectedCell] tag];
}
- (int) outputToStdout
{
	return [[outputToggle selectedCell] tag];
}
- (const char *) menu
{
	const char *p;
	p = [menuForm stringValueAt: 0];
	return (p ? p : "");
}

// actions
- filterOK: sender
{
	[activeFilter parameterChanged];
	[activeFilter update];
	[[stateManager scriptInspector] modified];
	return self;
}

// glues
- setFilterNameForm: anObject	{filterNameForm = anObject; } 
- setCommandForm: anObject	{commandForm = anObject; }
- setDestinationForm: anObject	{destinationForm = anObject; }
- setInputToggle: anObject		{inputToggle = anObject; }
- setOutputToggle: anObject		{outputToggle = anObject; }
- setMenuForm: anObject		{menuForm = anObject; }

@end
