#import <objc/Object.h>
#import <string.h>
#import <sys/wait.h>
#import <appkit/nextstd.h>
#import <dpsclient/dpsclient.h>
#import <appkit/graphics.h>

@interface Script:Object
{
// connectives
	id window;
	id miniwindow;
	id docView;
	id matrix;
	id textMatrix;
	id optionMatrix;
	NXRect docFrame;
	id stateManager;
	id inspector;
	id filterList;
	id activeFilter;
// behaviors
	char *scriptName;
	int confirm;
	int errorTerminate;
	int foreground;
	int iconType;
	char *resultIconPath;
	char *helpText;
// status
	int miniaturized;					// window / miniwindow
	char *iconPathList;					// dragged
	id    bitmap;						// icon of dragged
	int iconShown;					// already displayed target icon
	char *finalOutputFile;				// for getFileIconFor
	char *pathname;					// script file
	unsigned int globalWindowNum;		// to tell one window from another
	unsigned int globalMiniwindowNum;	// 	ditto
	int sizeChanged;					// to reduce matrix sizeToCells
	int flip;							// animation
	int selectedCol;					// to save/restore selected column
	int processing;
	DPSTimedEntry timedEntry;
	char *fromFile;					// status for sequential execution
	int filterIndex;						// status for sequential execution
	int firstFilter;						// animation
	int lastFilter;						// animation
}

+ initialize;
+ alloc;
- setStateManager: anObject;
- createWindow;
- addFilters;
- addFilter: newFilter;
- removeFilter;
- windowDidBecomeKey: sender;
- windowWillClose: sender;
- windowWillMiniaturize: sender toMiniwindow: aWindow;
- windowDidDeminiaturize: sender;
- matrixDidExchange: (int) index1 : (int) index2;
- (unsigned int) globalWindowNum;
- (unsigned int) globalMiniwindowNum;
- window;
- miniwindow;
- update;
- activate: sender;
- parameterChanged;
- (char *) scriptName;
- (int) confirm;
- (int) errorTerminate;
- (int) foreground;
- (int) iconType;
- (char *) resultIconPath;
- (char *) helpText;
- setPathname: (const char *) aString;
- (char *) pathname;
- write: (NXTypedStream *)ts;
- read: (NXTypedStream *)ts;
- buttonPressed;
- filterNameChanged;
- (int)iconEntered:(int)windowNum at:(double)x :(double)y
    iconWindow:(int)iconWindowNum iconX:(double)iconX iconY:(double)iconY
    iconWidth:(double)iconWidth iconHeight:(double)iconHeight
    pathList:(char *)pathList;
- (int)iconReleasedAt:(double)x :(double)y ok:(int *)flag;
- executeOneStep;
- childTerminated: (int) pid status: (union wait *) status;
@end

