/* Generated by Interface Builder */

#import "Postit.h"
#import "Tools.h"
#import "Preferences.h"
#import <appkit/nextstd.h>
#import <appkit/Application.h>
#import <appkit/Cursor.h>
#import <appkit/SavePanel.h>
#import <appkit/OpenPanel.h>
#import <appkit/ScrollView.h>
#import <objc/List.h>
#import <appkit/Window.h>
#import <appkit/Matrix.h>
#import <appkit/Text.h>

#import <streams/streams.h>
#import <string.h>

#define LEFT   225.0			/* where note windows appear */
#define TOP   810.0
#define YOFFSET  100.

#define MAXSIZE 1.0e38	
static int unique=1;

@implementation Postit

/// This is our ally which deals with NXDefault stuff and the Preference... Panel.
- setPrefObj:anObject
{
   prefObj=anObject;
   return  [prefObj getPreferences:self];   // init stuff
}
- createNewPostit:(const NXRect *)tFrame
{
    NXRect rect;
    NXSize csize;
    id tWin,theText,document;

    document = [ScrollView newFrame:tFrame];
    [document setVertScrollerRequired:YES];
    [document getContentSize:&csize];
    NXSetRect(&rect,0., 0., csize.width, csize.height);
    theText = [self newText:&rect];
    [document setDocView:theText];
    [theText setDelegate:self];
    [[theText superview] setAutoresizeSubviews:YES];
    [theText setAutosizing:NX_HEIGHTSIZABLE | NX_WIDTHSIZABLE];
    tWin = [Window newContent:tFrame style:NX_TITLEDSTYLE
	backing:NX_BUFFERED buttonMask:NX_ALLBUTTONS defer:NO];
    [tWin setContentView:document];
    [tWin setBackgroundGray:NX_WHITE];
    [tWin setFreeWhenClosed:YES];
    [tWin makeFirstResponder:theText];


//    sprintf(buf,"PostIt %d",unique++);
//    [tWin setTitle:buf];Thu Nov  2 23:11:24 MST 1989

    [tWin setTitle:DEFAULT_TITLE];
    
    [tWin setDelegate:self];
    [tWin setMiniwindowIcon:"Postit.tiff"];
    [tWin display];
    [tWin makeKeyAndOrderFront:self];
    [theText setSel:0:0];
    [theText showCaret];
    if (!windowList) windowList = [List new];
    [windowList addObject:tWin];

    return document;
}
- newPostit:sender
{
    /// Figure out which size postit the user wants, and its location.
    static NXPoint docLocation = {LEFT, TOP};
    NXRect r;
    NXSize screenSize;
    
    if ([sender respondsTo:@selector(tag)]) 
    	[prefObj getDefaultWinSize:&r.size tag:[[sender selectedCell] tag]];
     else [prefObj getDefaultWinSize:&r.size tag:3];  // 3 is for New/Open

    // Now make sure the window will fit at the next destined location
    [NXApp getScreenSize:&screenSize];
    if (docLocation.x > screenSize.width - r.size.width) {
	docLocation.x = LEFT;
        docLocation.y -= YOFFSET;   
    }

    if (docLocation.y  < r.size.height)	docLocation.y = TOP;
    r.origin.x =docLocation.x;
    r.origin.y = docLocation.y - r.size.height;
    // Update the next window location
    docLocation.x += r.size.width; 
     //We are all set, let's get the Postit
   return [self createNewPostit:&r];
}
/// Bruce Blumberg's text hack from TextLab
-newText:(const NXRect *)tF
{
	id text = [Text newFrame:tF text:NULL alignment:NX_LEFTALIGNED];
	[text setOpaque:YES];
	[text setFont:[prefObj defaultFont]];
	[[[[[text notifyAncestorWhenFrameChanged:YES]
		setVertResizable:YES]
		setHorizResizable:NO]
		setMonoFont:NO]
		setDelegate:self];
	
	{ NXSize aSize = {1.0E38,1.0E38};
	 [text setMinSize:&tF->size];
	 [text setMaxSize:&aSize];
        }
	[text setCharFilter:NXEditorFilter];
	return text;
}

- raiseAll:sender
{
    int i = [windowList count];
    while (i--) [[windowList objectAt:i] orderFront:sender];
    return self;
}
- lowerAll:sender
{
    int i = [windowList count];
    while (i--) [[windowList objectAt:i] orderBack:sender];
    return self;
}

- miniaturizeAll:sender
{
    int i = [windowList count];
    while (i--) [[windowList objectAt:i] miniaturize:sender];
    return self;
}

- saveAll:sender
{
    const char *fileName;
    id savePanel = [prefObj savepanel];
    if ([windowList count]==0) return self;     /// XXX disable menu in real life
    [savePanel setRequiredFileType:POSTIT_FILETYPE];
    if ([savePanel runModalForDirectory:[prefObj saveDirectory]
    	 file:[prefObj saveName]] &&(fileName = [savePanel filename])) {
	[self saveWindowListTo:fileName];
    }
    return self;
}
- autoSaveAll:sender
{
   const char *path;
   if ([prefObj autoSave]&&([windowList count])&&(path=[prefObj fullPath]))
      	return [self saveWindowListTo:path];
   return NULL;
}
- saveWindowListTo:(const char *)fileName
{
   NXTypedStream *ts;
   int i,count =[windowList count];
    ts = NXOpenTypedStreamForFile(fileName, NX_WRITEONLY);
    if (ts) {
	NXWriteType(ts, "i", &count);
	for (i=0;i<count;i++) {	
	    NXWriteRootObject(ts,[windowList objectAt:i]);
	    [[windowList objectAt:i] setDocEdited:NO];	}
	NXCloseTypedStream(ts);
    } else {
	NXRunAlertPanel("SaveAll", "Can't create file.","Ok",NULL,NULL);
    }
    return self;
}

- loadWindowList:(const char *)fileName
{
     NXStream *stream;
    if (stream = NXMapFile(fileName, NX_READONLY)) {
        [self readWindowListFromStream:stream];
	return self;
    } else {
	return nil;
    }
}

- readWindowListFromStream:(NXStream *)stream
{
    NXTypedStream *ts;
    int i,count;
    id win;
	[NXWait push];
	NX_DURING
	    ts = NXOpenTypedStream(stream, NX_READONLY);
	    if (ts) {
		NXReadType(ts, "i", &count);	/* howmany windows */
		for (i=0;i<count;i++) {
		    win = NXReadObject(ts);
    		    if (!windowList) windowList = [List new];
		   [windowList addObject:win];
		   [win setMiniwindowIcon:"Postit.tiff"];
    		   [win setDelegate:self];        // we must remove on close!!
		   [[[win contentView]docView] setDelegate:self];   // for docEdited
		   [[win display] makeKeyAndOrderFront:self];
		}
		unique += count;      // New postits will start number above this
   		NXCloseTypedStream(ts);
	    }	NX_HANDLER
	    NXCloseTypedStream(ts);
	    [NXWait pop];
	    return NULL;
	NX_ENDHANDLER
	[NXWait pop];
   	return self;
}

- loadAll:sender
{
    id openpanel = [prefObj openpanel];
    
    static const char *const types[2] = {POSTIT_FILETYPE, NULL};
    [openpanel setPrompt:"Notes File"];
    if ([openpanel runModalForDirectory:[prefObj saveDirectory]
    		file:[prefObj saveName] types:types]) {
	 [self loadWindowList:[openpanel filename]];
       }
     return self;
}

- newFromFile:(const char *)fileName
{
    NXStream *st;
    if (st = NXMapFile(fileName, NX_READONLY)) {
    	id document=[self newPostit:self];
	[NXWait push];
	if ([self isRich:st]) {
		[[document docView] readRichText:st];
	}
	else [[document docView] readText:st];
	[document display];
	[[document window] setTitle:fileName];
	NXCloseMemory (st, NX_FREEBUFFER);
	[NXWait pop];
	return document;
    } else {
    	return nil;
    }
}

- (BOOL) isRich:(NXStream *) st
{
	char buf[6];
	NXRead(st, buf, 5);
	buf[5] = '\0';
	NXSeek(st, 0, NX_FROMSTART); 	// rewind stream
	return (!(strcmp(buf, "{\\rtf")));	// note escaped '\'
}

// open allows either loading a group of Postits or single windows of any kind of text
- open:sender
{
    id openpanel = [prefObj openpanel];
//    static const char *const types[3] = {"",POSTIT_FILETYPE, NULL};
    const char *type,*filename;
    [openpanel setPrompt:"Any File:"];
    if ([openpanel runModalForDirectory:"." file:NULL types:NULL]) {   
        filename = [openpanel filename];
    	type = strrchr(filename, '.');
	if (!type) [self newFromFile:filename];
	else {
    		type++;   //get the file type suffix and move past the period
		if (!strcmp(type,POSTIT_FILETYPE)) [self loadWindowList:filename];
 		else if ([self newFromFile:filename] == nil)
			NXRunAlertPanel (NULL, "Could not open file.", "OK", NULL, NULL);
	}
     }
    return self;
}


// Delegate method for the document Text object. We use this method
// to detect when the text in the window is modified.
// Uncomment lines if you care if your postits are dirty....

- text:text isEmpty:(BOOL)empty
{
     if (![[NXApp keyWindow] isDocEdited]) 
        	[[NXApp keyWindow] setDocEdited:YES];
    return NO;
}

// saveDocument: will write out the contents of the document
// to the specified file. The best (perhaps not the cleanest but the
// most efficient) way to dump a Text object to a file seems to be
// to open the file (with open()), then to use NXOpenFile(), and
// finally use writeText: to dump the contents out.
- saveDocument:(const char *)fileName
{
    BOOL saveOK;
    int fd;     // File descriptor
    NXStream *stream = NULL;
    id win = [NXApp keyWindow];
    [NXWait push];
    if (saveOK = (((fd = open (fileName, O_WRONLY|O_CREAT|O_TRUNC, 0644)) != -1) &&
            (stream = NXOpenFile (fd, NX_WRITEONLY))))
	if([prefObj useRichText])[[[win contentView] docView] writeRichText:stream];
	else [[[win contentView] docView] writeText:stream]; 
    if (stream) NXClose(stream);
    if (fd != -1) close (fd);
    [NXWait pop];

    if (saveOK) {
      	[self setName:fileName];
	[[NXApp keyWindow] setDocEdited:NO];
    } else NXRunAlertPanel (NULL, "Can't write file.", "OK", NULL, NULL);

    return self;
}

// Set/Get the name of the document. This is the same as the title.

- setName:(const char *)documentName
{
    [[NXApp keyWindow] setTitle:documentName];
    return self;
}

-(const char *)name
{
    return [[NXApp keyWindow] title];
}

- windowWillClose:sender
{
    [sender setDelegate:nil];    [windowList removeObject:sender];    return sender;  // We need to return a non-nil value --- here's one.
}

- close:sender{
    [[NXApp keyWindow] close];  // This does *not* cause the window to
    return [self free];		// call the delegate method...
}

// save: saves the current document. If the document is untitled, it
// puts up a savePanel to get the user to enter a file name. saveAs:
// saves the document under a new name by putting up a savePanel.

- save:sender{
    const char *fileName = [self name];
    id savePanel = [prefObj savepanel];
    [savePanel setRequiredFileType:NULL];  //we don't care how you save stuff...
    if ((fileName == NULL) ||
	(strcmp (fileName, DEFAULT_TITLE) == 0) || (strcmp (fileName, "") == 0)) {
	 if ([savePanel runModalForDirectory:"." file:DEFAULT_TITLE] == NO)
	    return (self);
	 else {
	    fileName = [savePanel filename];
	 }
    }

    if (fileName) [self saveDocument:fileName];
    return self;
}
- saveAs:sender{
    id savePanel = [prefObj savepanel];
    if ([savePanel runModalForDirectory:"." file:[self name]]) {
	[self saveDocument:[savePanel filename]];
    }
    return self;
}

- saveTo:sender{
     id savePanel = [prefObj savepanel];
    if ([savePanel runModalForDirectory:"." file:[self name]]) {
	[self saveDocument:[savePanel filename]];
    }
    return self;
}
- revertToSaved:sender
/*
 * Revert the document back to what is on the disk.
 */ 
{
    NXStream *stream;
    id window = [NXApp mainWindow];
    const char *name = [self name];
    
    if (![window isDocEdited] || (NXRunAlertPanel("Revert", "%s has been edited.  Are you sure you want to undo changes?", "Revert", "Cancel", NULL, name) != NX_ALERTDEFAULT)) {
	return self;
    }
    stream = NXMapFile(name, NX_READONLY);
    if (stream){
    	[[[window contentView]docView] setText:""];
	if([self isRich:stream])[[[window contentView]docView] readRichText:stream];
	else [[[window contentView]docView] readText:stream];
	[window setDocEdited:NO];
	NXClose(stream);
    } else {
	if (stream) NXClose(stream);
	NXRunAlertPanel("Revert", "I/O error.  Can't revert.","Ok",NULL,NULL);
    }

    return self;
}

- print:sender
{ 
	return [[[[NXApp mainWindow]contentView]docView] printPSCode:sender];
}


@end
