
/*by andrew stone@hydra.unm.edu */
//Thu Nov  2 20:14:50 MST 1989

#import "Preferences.h"
#import "Postit.h"
#import "TLText.h"
#import <appkit/defaults.h>
#import <appkit/Application.h>
#import <appkit/Panel.h>
#import <appkit/OpenPanel.h>
#import <appkit/SavePanel.h>
#import <appkit/Form.h>
#import <appkit/Button.h>
#import <appkit/Text.h>
#import <appkit/FontManager.h>
#import <appkit/Font.h>
#import <appkit/Matrix.h>
#import <string.h>
#import <math.h>

#define PROGNAME "Tools"
#define DEFAULT_SAVE_PATH "$(HOME)/.postitDir"
#define DEFAULT_FILE_NAME "Notes"

@implementation Preferences

// Assert: getPreferences has initialized all vars. it is called by setPrefObj: in Postit
- runPrefsPanel:sender
{
    int i;
    [directoryField setStringValue:saveDirectory];
    [nameField setStringValue:saveName];
    
    for (i=0;i<NUM_WINDOWS;i++) {
	[[sizeForm cellAt:i :0] setIntValue:(int)width[i]];
	[[sizeForm cellAt:i :1] setIntValue:(int)height[i]];
    }
    [fileFormatMatrix selectCellAt:0 :useRichText];
    [autoSaveSwitch setState:autoSave];
    [sampleText setFont:[self defaultFont]];
    [sampleText setText:"Sample Font & Size"];
    [sampleText display];
    [prefPanel makeKeyAndOrderFront:self];
    return self;
}

- getPreferences:sender
{
    const char *value;
    int result;
    static NXDefaultsVector myDefaults = {
	{ "NewWindowW", "500" },
	{ "NewWindowH", "200" },
	{ "SmallPostitW", "120" },
	{ "SmallPostitH", "40" },
	{ "MediumPostitW", "200" },
	{ "MediumPostitH", "100" },
	{ "LargePostitW", "300" },
	{ "LargePostitH", "200" },
	{ "PostitSavePath", DEFAULT_SAVE_PATH },
	{ "PostitSaveName", DEFAULT_FILE_NAME },
	{ "Font", "Times-Roman"},
	{ "FontSize", "12"},
	{ "ReadRichText","0"},
	{ "AutoSave","0"},
	{ NULL }
    };
    result =NXRegisterDefaults(PROGNAME, myDefaults);
    
    value = NXGetDefaultValue(PROGNAME, "NewWindowW");
    if (value) {
	width[3] = atof(value);
	value = NXGetDefaultValue(PROGNAME, "NewWindowH");
	height[3] = atof(value);
    } else { width[3] = 288.;height[3] = 144.; }
    
    value = NXGetDefaultValue(PROGNAME, "SmallPostitW");
    if (value) {
	width[0] = atof(value);
	value = NXGetDefaultValue(PROGNAME, "SmallPostitH");
	height[0] = atof(value);
    } else { width[0] = 288.;height[0] = 144.; }
    
    value = NXGetDefaultValue(PROGNAME, "MediumPostitW");
    if (value) {
	width[1] = atof(value);
	value = NXGetDefaultValue(PROGNAME, "MediumPostitH");
	height[1] = atof(value);
    } else { width[1] = 400.;height[1] = 400.; }
    
    value = NXGetDefaultValue(PROGNAME, "LargePostitW");
    if (value) {
	width[2] = atof(value);
	value = NXGetDefaultValue(PROGNAME, "LargePostitH");
	height[2] = atof(value);
    } else { width[2] = 600.;height[2] = 300.; }
    
    value = NXGetDefaultValue(PROGNAME, "PostitSavePath");
    if (value) {
        strcpy(saveDirectory,value);
    } else strcpy(saveDirectory,DEFAULT_SAVE_PATH);
    
    value = NXGetDefaultValue(PROGNAME, "PostitSaveName");
    if (value) {
        strcpy(saveName,value);
    } else strcpy(saveName,DEFAULT_FILE_NAME);    
    
    value = NXGetDefaultValue(PROGNAME, "FontSize");
    if (value) {
	fontSize = atof(value);
        strcpy(fontName,NXGetDefaultValue(PROGNAME, "Font"));
     } else {fontSize=12.;strcpy(fontName,"Times-Roman");}
     
     value = NXGetDefaultValue(PROGNAME,"ReadRichText");
     if (value) useRichText = value[0]=='1'?YES:NO;
     
     value = NXGetDefaultValue(PROGNAME,"AutoSave");
     if (value) autoSave = value[0]=='1'?YES:NO;
         
    return self;
}

- registerDefaults:sender
{
    char buf[16];
    id font;
    int i;
    for (i=0;i<NUM_WINDOWS;i++) {
    	width[i] = [[sizeForm cellAt:i :0]floatValue];
    	height[i] = [[sizeForm cellAt:i :1] floatValue];
    }
    sprintf(buf,"%d\0",(int)width[0]);
    NXWriteDefault(PROGNAME,"SmallPostitW",buf); 
    sprintf(buf,"%d\0",(int)height[0]);
    NXWriteDefault(PROGNAME,"SmallPostitH",buf); 
    
    sprintf(buf,"%d\0",(int)width[1]);
    NXWriteDefault(PROGNAME,"MediumPostitW",buf); 
    sprintf(buf,"%d\0",(int)height[1]);
    NXWriteDefault(PROGNAME,"MediumPostitH",buf); 
    
    sprintf(buf,"%d\0",(int)width[2]);
    NXWriteDefault(PROGNAME,"LargePostitW",buf); 
    sprintf(buf,"%d\0",(int)height[2]);
    NXWriteDefault(PROGNAME,"LargePostitH",buf); 
    
    sprintf(buf,"%d\0",(int)width[3]);
    NXWriteDefault(PROGNAME,"NewWindowW",buf); 
    sprintf(buf,"%d\0",(int)height[3]);
    NXWriteDefault(PROGNAME,"NewWindowH",buf); 
       
    [self changeSaveDirectory:[directoryField stringValue] forName:[nameField stringValue]];
    NXWriteDefault(PROGNAME,"PostitSavePath",saveDirectory);
    NXWriteDefault(PROGNAME,"PostitSaveName",saveName);
    openpanel=savepanel=NULL;   /// they will get new info lazily.
    
    font = [sampleText font];
    strcpy(fontName,[font name]);
    fontSize = [font pointSize];
    NXWriteDefault(PROGNAME,"Font",fontName);
    sprintf(buf,"%d\0",(int)fontSize);
    NXWriteDefault(PROGNAME,"FontSize",buf);
    
    useRichText = [fileFormatMatrix selectedCol];
    NXWriteDefault(PROGNAME,"ReadRichText",useRichText?"1":"0");
    
    autoSave = (BOOL)[autoSaveSwitch state];
    NXWriteDefault(PROGNAME,"AutoSave",autoSave?"1":"0");

    [prefPanel orderOut:self];
    return self;
}



////////////// File stuff
- (BOOL)autoSave
{
  return autoSave;
}

- changeSaveDirectory:(const char *)dir forName:(const char *)fname
{
    if (!dir) saveDirectory[0]='\0';
    else strcpy(saveDirectory,dir);
    if (!fname) saveName[0]='\0';
    else strcpy(saveName,fname);
    return self;
}

- openpanel
{
  if (!openpanel) {
  	openpanel = [OpenPanel new];
  	[openpanel setDirectory:saveDirectory];
  }
  return openpanel;
}
- savepanel
{
  if (!savepanel){
  	savepanel = [SavePanel new];
  	[savepanel setDirectory:saveDirectory];
  }
  return savepanel;
}

- (const char *)saveDirectory
{
    return saveDirectory;
}

- (const char *)saveName
{
    return saveName;
}
- (const char *)fullPath
{
   static char buf[1024];     /// Must be static!!!
   if (saveDirectory&&saveName) {
      strcpy(buf,saveDirectory);
      strcat(buf,"/");
      strcat(buf,saveName);
      strcat(buf,".");
      strcat(buf,POSTIT_FILETYPE);
      return buf;
   } else return NULL;
}

- getDefaultWinSize:(NXSize *)size tag:(int)num
{
    if (num>3||num<0)num=3;   // sanity
    size->width = width[num];
    size->height = height[num];
    return self;
}

- setSizeForm:anObject
{
    int i;
    sizeForm = anObject;
    for (i=0;i<NUM_WINDOWS;i++) {
    	[[sizeForm cellAt:i :0]setFloatingPointFormat:NO left:3 right:0];
    	[[sizeForm cellAt:i :1]setFloatingPointFormat:NO left:3 right:0];
    }
    return self;
}

- setPrefPanel:anObject
{
    prefPanel = anObject;
    return self;
}


- setDirectoryField:anObject
{
    directoryField = anObject;
    return self;
}


/////////// Font preference stuff

- (BOOL)useRichText			/// which file format to use: 1=rtf
{
	return useRichText;
}
- defaultFont
{
   return [Font newFont:fontName size:fontSize];
}
- showFontPanel:sender
{
   id fm = [FontManager new];
   [sampleText selectAll:self];
   return [fm orderFrontFontPanel:self];
}
- setSampleText:anObject
//// We need a real text object to extract font info from
{  
   sampleText = anObject;
   [sampleText setText:"Sample Font & Size"];
   [sampleText setOpaque:YES];
   [sampleText setFontPanelEnabled:YES];
   [sampleText setMonoFont:YES];
   [sampleText setBackgroundGray:NX_WHITE];
   [sampleText setDelegate:self];
   [sampleText display];
   return self;
}

- setFileFormatMatrix:anObject
{
   fileFormatMatrix = anObject;
   return self;
}
- setAutoSaveSwitch:anObject
{
    autoSaveSwitch=anObject;
    return self;
}
- setNameField:anObject
{
    nameField=anObject;
    return self;
}
@end
