/*
 * this is a simple tool to scan quoted strings recognizing backslash
 * and paired single-character quotes e.g. "string" or 'string'.
 */
#include <stdio.h>
extern char *malloc(), *realloc();
extern char *strchr();
#include "tquote.h"

static int iLine = 1;
static int iFatals = 0;

char *TQpcFileName = "<stdin>";	/* the name of the input file		*/
int *TQpiLine = & iLine;	/* what line are we on?			*/
int *TQpiFatals = & iFatals;	/* count of fatal errors we find	*/

/*
 * These adjust the configuration.  Sorry, you can't configure the NUL
 * character into any of these.  If you specify TQcEscape as the NUL
 * character, escapes are disabled.
 *
 * These are context dependend, but when applicable, they are checked in the
 * order given.  For example, newline appears in several of the default
 * strings -- after a backslash, it's a null-effect; inside quotes, it's a
 * terminator; at the beginning of a string, it's an IFS character.
 *
 * characters given in TQpcTerminate usually also appear in TQpcIFS
 */
char TQcEscape = '\\';		/* the "escape" character or NUL	*/
char *TQpcNullEffect = "\n";	/* escaped, these are *empty* 		*/
char *TQpcTerminate = "\n";	/* can not be quoted			*/
char *TQpcIFS = " \t\n";	/* terminates string if not quoted	*/
char *TQpcQuote = "\"\'";	/* quote character(s)			*/

/*
 * read an abitrarily long string (limited maximum available dynamic
 * memory) recognizing backslash-type quotes and pairs of like quotes,
 * e.g. "string" or 'string'.
 *
 * semantics:
 *	the "escape" character makes any character except those in
 *		TQpcNullEffect and TQpcTerminate literal
 *	"escape" with a character from TQpcNullEffect is the empty string
 *	quotes quote each other e.g. "abc'def" or 'abc"def'
 *	if not quoted, character in TQpcIFS terminate the string
 *
 * return the string without any of the quotes -- The memory is dynamically
 * allocated and may be free'd with call to free().
 *
 * return (char *)0 on failure
 */
char *
TQScan(pFI, piCurChar, uiPredictedLength, uiIncrement, puiLength)
	FILE *pFI;			/* file from which to scan	*/
	int *piCurChar;			/* "current" character		*/
	unsigned int uiPredictedLength;	/* expected string length	*/
	unsigned int uiIncrement;	/* amount to add on each time	*/
	unsigned int *puiLength;	/* if non nil, returns strlen	*/
{
	register int iCurChar;
	register char *pc;
	register unsigned int uiLength;
	register unsigned int uiLeft;
	register int iQuote;
	register char *pcReturn;

	iCurChar = *piCurChar;

	/*
	 * allocate the first string buffer
	 */
	if ((char *)0 == (pcReturn = pc = malloc((unsigned int)uiPredictedLength * sizeof(char)))) {
		return (char *)0;
	}
	uiLength = (unsigned int)0;
	uiLeft = uiPredictedLength;
	/*
	 * we begin from the top of this look for each character we
	 * may save
	 */
	iQuote = '\000';
	for (;;) {
		/*
		 * make sure we always have room for at least one character
		 *
		 * When we break the loop, we're going to blindly add a NUL
		 * character to the string.
		 */
		if ((unsigned int)0 == uiLeft) {
			pcReturn = pc = realloc(pcReturn, uiLength + uiIncrement);
			pc += (int)uiLength;
			uiLeft = uiIncrement;
		}
		/*
		 * process all "escape" character processing
		 */
		if ('\000' != TQcEscape && TQcEscape == iCurChar) {
			iCurChar = getc(pFI);
			if (EOF == iCurChar) {
				++*TQpiFatals;
				fprintf(stderr, "%s: (line %d) fatal: escaped end of file\?!\n", TQpcFileName, *TQpiLine);
				break;
			}
			/*
			 * handle all null-effect escapes
			 */
			if ((char *)0 != strchr(TQpcNullEffect, iCurChar)) {
				iCurChar = getc(pFI);
				if ('\n' == iCurChar) {
					++*TQpiLine;
				}
				continue;
			}
			/*
			 * make sure we are not about to eat an important
			 * syncronization character (usually newline)
			 */
			if ((char *)0 != strchr(TQpcTerminate, iCurChar)) {
				++*TQpiFatals;
				fprintf(stderr, "%s: (line %d) fatal: can not escape char: 0x%02x\n", TQpcFileName, *TQpiLine, iCurChar);
				break;
			}

		} else if ('\000' == iQuote) {
			/*
			 * we are *not* inside quotes -- IFS characters
			 * terminate the string
			 */
			if ((char *)0 != strchr(TQpcIFS, iCurChar))
				break;

			/*
			 * check for open quote
			 *
			 * If the quote character is a newline, we don't bother
			 * to increment the line -- it probably doesn't matter
			 * in this case.
			 */
			if ((char *)0 != strchr(TQpcQuote, iCurChar)) {
				iQuote = iCurChar;
				iCurChar = getc(pFI);
				continue;
			}

		/*
		 * inside quotes
		 */
		} else if (iQuote == iCurChar) {
			/*
			 * closing quote
			 */
			iQuote = '\000';
			iCurChar = getc(pFI);
			continue;

		} else if (EOF == iCurChar || (char *)0 != strchr(TQpcTerminate, iCurChar)) {
			/*
			 * illegal inside quotes
			 */
			++*TQpiFatals;
			fprintf(stderr, "%s: (line %d) fatal: missing close quote!\n", TQpcFileName, *TQpiLine);
			break;
		}
		/*
		 * just a character, accumulate it
		 */
		if ('\n' == iCurChar) {
			++*TQpiLine;
		}
		*pc++ = iCurChar;
		++uiLength;
		--uiLeft;
		iCurChar = getc(pFI);
	}
	/*
	 * don't count the trailing NUL character in the length
	 */
	*pc = '\000';
	*piCurChar = iCurChar;
	if ((unsigned int *)0 != puiLength) {
		*puiLength = uiLength;
	}
	return pcReturn;
}

/*
 * print routine and test driver removed from here
 * see Ksb's and Dsg's "parts" library for the rest
 */
