/* File: Unknown.m - The 'Unknown' Application
 *
 * By: Christopher Lane
 * Symbolic Systems Resources Group
 * Knowledge Systems Laboratory
 * Stanford University
 *	
 * Contributor(s):
 *	
 *     Jiro Nakamura (jiro@heights.cit.cornell.edu)
 *
 * Date: 25 January 1991
 *
 * Copyright: 1989, 1990 & 1991 by The Leland Stanford Junior University.
 * This program may be distributed without restriction for non-commercial use.
 */
 
#import "Unknown.h"

#import <c.h>
#import <libc.h>
#import <stdlib.h>
#import <ldsyms.h>
#import <strings.h>

#import <sys/file.h>
#import <sys/loader.h>

#import <objc/typedstream.h>
#import <objc/HashTable.h>

#import <appkit/Panel.h>
#import <appkit/defaults.h>

// #import <text/pathutil.h>

#define APPLICATION "Unknown"

#define VERIFYDEFAULTSTRING "Verify"
#define DEFAULTVERIFYSTRING "Yes"
#define REPORTERRORDEFAULTSTRING "ReportError"
#define DEFAULTREPORTERRORSTRING "Yes"

#define getDefaultValue(s) NXGetDefaultValue(APPLICATION, s)
#define registerDefaults(s) NXRegisterDefaults(APPLICATION, s)

#define getDefaultBoolValue(s) (BOOL) (strncmp(getDefaultValue(s), "Yes", 1) == EQ)

static NXDefaultsVector UnknownDefaults = {
	{ VERIFYDEFAULTSTRING, DEFAULTVERIFYSTRING },
	{ REPORTERRORDEFAULTSTRING, DEFAULTREPORTERRORSTRING },
	{ NULL }
	};

#define SEGMENT "__HASHTABLE"
#define SECTION "__DATA"

#define BUFFERSIZE 512
#define BITSPERBYTE 8

#define EXECUTESTRING "Execute?"
#define ERRORSTRING "Error running '%s', exit code = %d."

#define DEFAULTBUTTON "OK"
#define ALTERNATEBUTTON "Cancel"

typedef enum { LT = -1, EQ, GT } COMPARISON;

char *basename(char *path)
{ 
	char *s;
	
	if((s = rindex(path, '/')) != NULL) return ++s;
	
	return path;
}

char *parentname(char *path)
{ 
	char *p, *s = NXCopyStringBuffer(path);
	
	if((p = rindex(s, '/')) == NULL) { p = s; *p++ = '.'; }
		
	*p = '\0';
	
	return s;
}

@implementation Unknown : Application

+ new
{
	self = [super new];
    
	(void) registerDefaults(UnknownDefaults);
	
	return self;
}

- (BOOL) appAcceptsAnotherFile:sender { return(YES); };

- (int) appOpenFile:(const char *) filename type:(const char *) aType
{
	int status;
	char buffer[BUFFERSIZE];
	const char *program, *base = basename((char *) filename);
	HashTable *table = [self loadSegment:SEGMENT section:SECTION];

	if(access(filename, R_OK) == CERROR) return (int) [self unix_error:"access"];
	if(chdir(parentname((char *) filename)) == CERROR) return (int) [self unix_error:"chdir"];
		
	if((program = [table valueForKey:aType]) != NULL) {
		sprintf(buffer, program, base, base, base, base, base);
		if(! getDefaultBoolValue(VERIFYDEFAULTSTRING) ||
		  (NXRunAlertPanel(EXECUTESTRING, buffer, DEFAULTBUTTON, ALTERNATEBUTTON, NULL) == NX_OKTAG)) {
		  	if((status = system(buffer)) == CERROR) return (int) [self unix_error:"system"];
			status >>= BITSPERBYTE;
			if(status != EXIT_SUCCESS && getDefaultBoolValue(REPORTERRORDEFAULTSTRING))
				NXRunAlertPanel(NULL, ERRORSTRING, NULL, NULL, NULL, buffer, status);
			}
		}

	return(YES);
}

- appDidInit:sender { return [self terminate:sender]; }

- loadSegment:(const char *) segment section:(const char *) section
{
	int size;
	id object;
	void *pointer;
	NXStream *stream;
	NXTypedStream *typedstream;
	
	pointer = getsectdata(segment, section, &size);
	stream = NXOpenMemory((const char *) pointer, size, NX_READONLY);
	typedstream = NXOpenTypedStream(stream, NX_READONLY);
	object = NXReadObject(typedstream);
	NXCloseTypedStream(typedstream);

	return object;
}

- (BOOL) unix_error:(const char *) string
{
    perror(string);
    return(NO);
}

@end
