// utility to look up a word from the dictionary 	
// shameless stolen from the man pages
// look at "man webster" for more info
// 
// written on October 15, 1989 
// modified on October 20, 1990
// by jiro nakamura
// 
// parts of this may be copyrighted by NeXT or 
// by the people at Merriam-Webster
// check before copying.
//

//#include <text/webster.h>
#include "/usr/local/include/webster.h"
#include <stdio.h>
#include <strings.h>
int printerror();
int find(char *word, char *dict);

int
main(argc,argv)
int argc;
char **argv;
{			
	if( (argc < 2) || (argc > 4))
		{
		printerror();
		return(0);
		}
		
	if( strcmp("-t",argv[1]) == 0)
		find(argv[2],"Webster-Thesaurus");
	else {
		if( strcmp("+t",argv[1]) == 0)
			{
			find(argv[2],"Webster-Dictionary");
			find(argv[2],"Webster-Thesaurus");
			}
		else 
			find(argv[1],"Webster-Dictionary");
		}
	return(0);
}		
	
int printerror()
{
fprintf(stderr,
	"define: defines a word from Merriam-Websters Dictionary and Thesaurus.\n"
	"        by Jiro Nakamura, 1989.\n\n"
	"		Usage:		define [-t +t] word\n"
	"				+t	include thesaurus with definition\n"
	"				-t	use only the thesaurus\n"
	"				word	word to define\n\n");
return(0);
}

/* function that actually looks up the words */

	
int find(char *word, char *dict)
{
	ReferenceBook *book;
	Definition *d;
	int exact = 1;


	printf("Defining <%s> with %s.\n",word,dict);
	 book = referenceOpen(dict);
	dictionaryFoldSenses = 60; /* fold output lines to 60 chars */
	if (d = getDefinition(word, book, !exact))
	{
		do
			{
			printf("--------------------------------\n");
			 putDefinition(d, 0);
			 freeDefinition(d);
			}
		while( d=getNextDefinition(word,book,exact));
			  
		printf("\n\n");
			}
		       
	referenceClose(book);
	return(1);
}

