/* 
   Modifies a keymap to produce new shift-return, -tab and/or -delete
   characters.  Note that the standard return key entry defines return
   and command-return, we modify it to define return and shift-return.
   This means that you lose the ability to produce command-return if 
   you map shift-return.  The other key entries already specify shifted 
   characters, so we just change the character produced.

   Compile with: cc -o shiftmap -O -s -object shiftmap.c
   Usage: shiftmap options < /NextLibrary/Keyboards/USA.keymapping >
	  ~/Library/Keyboards/USAcustom.keymapping
   Quit Preferences and restart it.  Select your new keymapping from
   the keyboard item and the new keymapping will be installed.
   I remapped my keyboard as shiftmap -d '|' -r '\' -t '`' < 
   /NextLibrary/Keyboards/USA.keymapping > ~/Library/Keyboards/Mike.keymapping
   
   This code is public domain.  It is a quick hack that has worked for me,
   but it surely isn't pretty.  Contact carlton@cs.berkeley.edu if you
   have comments or suggestions.  It is known to work on the USA standard
   keymapping, but may fail for the other keymappings.

   This program wouldn't be as much of a hack if I could find documentation 
   on the format of keymappings.  This wouldn't even be necessary if the
   Keyboard application from the 2.0 release did a more thorough job.  

   There is a hint that documentation does exist, but I don't know where
   to get a copy of it.  Man 4 evs reveals this tantalizing tidbit:
   	"See the document ``Key Mappings on the NeXT Computer'' for more 
	 details on a key mapping string.  Key mappings are created by 
	 the KeyMap utility program."
   If anyone can send either of these to me, I would be very grateful.

   To answer one question I've already gotten a couple of times: no, I
   don't know how to disable or remap the brightness, sound or power keys.
   I suspect that they may be in the same keymapping, but I did not 
   completely decipher the keymapping format, and just don't know if they
   are in there or not.

   Mar. 1, 1991
   Mike Carlton	
*/

#include <stdio.h>
#include <sys/types.h>
#include <nextdev/keycodes.h>

#define SHIFT_ENTRY	stx
#define CMD_ENTRY	eot

enum {
	retrn,
	tab,
	delete,
	num_maps
};

char map[][4] = {
	{ CMD_ENTRY,   nul,  cr, nul }, 	/* Next char is cmd-return */
	{ SHIFT_ENTRY, nul,  ht, nul }, 	/* Next char is shift-tab */
	{ SHIFT_ENTRY, nul, del, nul } 		/* Next char is shift-delete */
};

char *name[] = {
	"return", "tab", "delete"
};

char newchar[num_maps];

void usage(char *program)
{
	fprintf(stderr, "Usage: %s [-r char] [-t char] [-d char]\n\n", program);
	fprintf(stderr, 
	"Reads a keymap on stdin and writes modified one to stdout.\n");
	fprintf(stderr, 
	"The options specify the new character to produce when shift\n");
	fprintf(stderr, "return, tab or delete is pressed, respectively.\n");
}


int main(int argc, char *argv[])
{
	int i, j, bytes, changed = 0;
	char c, buf[4096], *key, *lim;
	extern int optind;
	extern char *optarg;

	if (argc == 1) {
		usage(argv[0]);
		exit(1);
	}

        while ((c = getopt(argc, argv, "r:t:d:")) != EOF)
        	switch (c) {
                    case 'r':
			newchar[retrn] = optarg[0];
                    	break;
                    case 't':
			newchar[tab] = optarg[0];
                    	break;
                    case 'd':
			newchar[delete] = optarg[0];
                    	break;
		    default:
			usage(argv[0]);
			exit(1);
			break;
		}


	bytes = fread(buf, sizeof(char), 1024, stdin);
	key = buf;
	lim = key+bytes;

	while (key < lim-4) {
		for (i = 0; i < num_maps; i++)
			if (newchar[i]) {
				for (j = 0; j < 4; j++)
					if (key[j] != map[i][j])
						break;

				if (j == 4) {	   /* we matched */
					key[0] = SHIFT_ENTRY;  /* for return */
					key[4] = newchar[i];
					fprintf(stderr, "Remapping shift-%s\n",
						name[i]);
					changed++;
					break;
				}
			} 
		key++;
	}

	if (!changed) 
		fprintf(stderr, "No keys found to remap\n");

	fwrite(buf, sizeof(char), bytes, stdout);

	return 0;
}
