
/*	Program By Fred Richards, Copyright 1990.	*/
/*							*/
/*	This software is provided free of charge	*/
/*	and without warranty.  The source code may	*/
/*	be distributed freely provided this copyright	*/
/*	notice remains in tact.				*/


#import <objc/Object.h>
#import <appkit/appkit.h>

@interface Plot:Object
{
    id	canvas;		// PlotView
    id	xMin;		// Text forms in control panel
    id	yMax;
    id	yMin;
    id	xMax;
    id	plotBox;	// The box around PlotView
    
    NXPoint *data;	// 2-D data set (pairs of floats)
    int    dCount;	// number of points in the set

    NXPoint  min;	// minima for x and y (for display purposes)
    NXPoint  max;	// maxima for x and y
    NXPoint  dMin;	// minima for x and y (determined from the data file)
    NXPoint  dMax;	// maxima for x and y

    BOOL   minmax;	// YES = use the min and max in the control panel,
			// NO = get min and max from the data

    BOOL   lines;	// YES = connect points with lines
    BOOL   axes;	// YES = draw axes for x=0 and y=0
    BOOL   border;	// YES = draw a border around the plot
    int    style;	// shape of the data points:
			//	0 = dots
			//	1 = cross (+)
			//	2 = ex's (x)
			//	3 = box
			//	4 = triangles

    char  *fileName;	// Name of the PostScript file for output
}

// The following methods attach this object to the QuickPlot window

- setCanvas:anObject;
- setXMin:anObject;
- setYMax:anObject;
- setYMin:anObject;
- setXMax:anObject;
- setPlotBox:anObject;

// These methods return the value of the instance variables

- (BOOL )border:sender;
- (BOOL )axes:sender;
- (BOOL )lines:sender;
- (int )style:sender;

- (NXPoint *)data;
- (int )dSize;

- (NXCoord )ymax:sender;
- (NXCoord )ymin:sender;
- (NXCoord )xmin:sender;
- (NXCoord )xmax:sender;

- (char *)fileName:sender;

// These methods are called by the control panel objects to
// *set* the instance variables

- setLines:sender;
- setAxes:sender;
- setBorder:sender;
- setStyle:sender;
- setMinmax:sender;

// Get the min and max values from the control panel

- getXmin:sender;
- getXmax:sender;
- getYmin:sender;
- getYmax:sender;

// If the min and max came from a file, use these messages to
// update the TextForms in the control panel

- resetXmax:sender;
- resetXmin:sender;
- resetYmax:sender;
- resetYmin:sender;

- setBoxTitle:(char *)aTitle;

- setFileName:(char *)aPSfile;

- setMinmax:sender;

// This method will do all the work

- drawPlot:sender;

// Allocate memory for and read the data from the specified file/stream

- (int )readDataFrom:(FILE *)aDataStream;

// get the min and max from the data

- findMinAndMax;

// send the right min and max to the PlotView

- (BOOL )setupBorder:sender;

// These methods are called from the main menu

- open:sender;
- openFile:(char *)aDataFile;
- save:sender;
- saveAs:sender;

@end
