
/* Generated by Interface Builder */

#import "defs.h"
#import "Plot.h"
#import "PlotView.h"		/*  for initializeLegendBox and savePSCode*/
/* will get warning message from compiler if preceding line is commented out */
#import <appkit/Button.h>
#import <appkit/OpenPanel.h>
#import <appkit/SavePanel.h>
#import <appkit/Matrix.h>
#import <appkit/Cell.h>
#import <appkit/appkit.h>
#import <objc/Storage.h>
#import <math.h>		/* for MAXFLOAT, etc. */
#import <strings.h>
#import <streams/streams.h>

/* The following routines are in auxil.c: */
extern void computeNiceLinInc(float *, float *, float *);
extern void computeNiceLogInc(float *, float *, float *);

@implementation Plot

+ new				/* should use alloc and init?  */
{
  self = [[super alloc] init];
  // Initialize variables here:
  nfilestotal = 0;
  ncurvestotal = 0;
  globaldatamin.x = MAXFLOAT;
  globaldatamin.y = MAXFLOAT;
  globaldatamax.x = -MAXFLOAT;
  globaldatamax.y = -MAXFLOAT;
  ticmarkdir = 1;
  return self;
}

// Delete all data (free up the space that was malloc'ed)
- removeAllFiles:sender
{
  int n = nfilestotal, j;
  datahunk *pdh;

  for (n=0; n<nfilestotal; n++) {
    pdh = (datahunk *)[datahunkList elementAt:(unsigned)n];
    for (j = 0; j < pdh->ncurves; j++) {
      free( (void *)*(pdh->y+j) );
    }
    free( (void *)(pdh->y) );
    free( (void *)(pdh->x) );
    free( (void *)(pdh->filename) );
  }
  [self adjustPanels:ncurvestotal :-1]; /* -1 is a special signal */
  nfilestotal = 0;
  [canvas display];		/* clear the canvas */
  ncurvestotal = 0;

  // get rid of "remove all files" panel
  [ [sender window] close];

  // reset globaldatamin/max
  globaldatamin.x = MAXFLOAT;
  globaldatamin.y = MAXFLOAT;
  globaldatamax.x = -MAXFLOAT;
  globaldatamax.y = -MAXFLOAT;

  // clear xMin/Max/Inc and yMin/Max/Inc windows:
  [xMin setStringValue:"" at:0];
  [xMax setStringValue:"" at:0];
  [xInc setStringValue:"" at:0];
  [yMin setStringValue:"" at:0];
  [yMax setStringValue:"" at:0];
  [yInc setStringValue:"" at:0];

  return self;
}

// Remove all existing files and open a new one
// Should we put up a warning panel here?
- removeAndOpen:sender
{
  [self removeAllFiles:sender];
  [self open:self];
  return self;
}

/* return the x data for the nth file */
- (NXCoord *)xdata:(int)n
{
  datahunk *pdh;

  pdh = (datahunk *)[datahunkList elementAt:(unsigned)n];
  return pdh->x;
}

/* return the y data for the nth file */
- (NXCoord **)ydata:(int)n
{
  datahunk *pdh;

  pdh = (datahunk *)[datahunkList elementAt:(unsigned)n];
  return pdh->y;
}

/* return the number of x-points in the nth file */
- (int)nPoints:(int)n
{
  datahunk *pdh;

  pdh = (datahunk *)[datahunkList elementAt:(unsigned)n];
  return pdh->npoints;
}

/* return the number of curves in the nth file */
- (int)nCurves:(int)n
{
  datahunk *pdh;

  pdh = (datahunk *)[datahunkList elementAt:(unsigned)n];
  return pdh->ncurves;
}

- (int)nCurvesTotal     { return ncurvestotal;}

- (int)nFiles           { return nfilestotal;}

- (const char *)provideXTitle       {return [xTitle stringValueAt:0];}
- (const char *)provideYTitle       {return [yTitle stringValueAt:0];}
- (const char *)provideMainTitle    {return [mainTitle stringValueAt:0];}

- (const char *)provideCurveTitle:(int)aCurve
{
  return [legendForm stringValueAt:aCurve];
}

- (const char *)provideLegendTitle
{
  return [legendTitle stringValueAt:0];
}

- makeXTitle:(char *)title    { return [xTitle setStringValue:title at:0]; }
- makeYTitle:(char *)title    { return [yTitle setStringValue:title at:0]; }
- makeMainTitle:(char *)title { return [mainTitle setStringValue:title at:0]; }

- makeCurveTitle:(int)aCurve :(char *)title
{
  return [legendForm setStringValue:title at:aCurve];
}

- makeLegendTitle:(char *)title
{
  return [legendTitle setStringValue:title at:0];
}

- makeLineStyle:(int)aCurve :(int)lineStyle
{
  int   row;

  for (row = 0; row < N_LINE_STYLES; row++)
    [[lineMatrix cellAt:row :aCurve] setState:0]; /* turn off all */
  [[lineMatrix cellAt:lineStyle :aCurve] setState:1];
  return self;
}

- makeSymbolType:(int)aCurve :(int)symType;
{
  int   row;

  for (row = 0; row < N_SYMBOL_STYLES; row++)
    [[symbolMatrix cellAt:row :aCurve] setState:0]; /* turn off all */
  [[symbolMatrix cellAt:symType :aCurve] setState:1];
  return self;
}

- makeLineThickness:(int)choice;
{
  int i;

  for (i = 0; i < N_LINE_THICKNESSES; i++)
    [lineThickness setState:0 at:0 :i];
  [lineThickness setState:1 at:0 :choice];
  return self;
}

- makeSymbolSize:(int)choice;
{
  int i;

  for (i = 0; i < N_SYMBOL_TYPES; i++)
    [symbolSize setState:0 at:0 :i];
  [symbolSize setState:1 at:0 :choice];
  return self;
}

- (BOOL) shouldDrawLegend
{
  if ( [legendOnOff state] ) return YES;
  else return NO;
}

- maybeDrawLegend:(int) i
{
  return [legendOnOff setState:i];
}

- (BOOL) shouldDrawLegendBox
{
  if ( [legendBoxOnOff state] ) return YES;
  else return NO;
}

- maybeDrawLegendBox:(int) i
{
  return [legendBoxOnOff setState:i];
}

- (BOOL) shouldDrawGrid
{
  if ( [gridOnOff state] ) return YES;
  else return NO;
}

- maybeDrawGrid:(int) i
{
  return [gridOnOff setState:i];
}

- (float) provideBorderBoxThickness
{
  return [borderBoxThickness floatValue];
}

- forceBorderBoxThickness:(float)t
{
  [borderBoxThickness setFloatValue:t];
  return self;
}

- (BOOL) shouldMoveLegend
{
  if ( [legendMove state] ) return YES;
  else return NO;
}

- (BOOL) doZoom
{
  if ( [zoomOnOff state] ) return YES;
  else return NO;
}

- (BOOL) xaxisLog
{
  if ( [xLinLog state] ) return YES;
  else return NO;
}

- forceXaxisLinear
{
  [xLinLog setState:0];
  [xLinLog display];
  return self;
}

- forceXaxisLog
{
  [xLinLog setState:1];
  [xLinLog display];
  return self;
}

- (BOOL) yaxisLog
{
  if ( [yLinLog state] ) return YES;
  else return NO;
}

- forceYaxisLinear
{
  [yLinLog setState:0];
  [yLinLog display];
  return self;
}

- forceYaxisLog
{
  [yLinLog setState:1];
  [yLinLog display];
  return self;
}

- (BOOL) shouldChangeLegendFont
{
  if ( [changeLegendFont state] ) return YES;
  else return NO;
}

- (BOOL) shouldChangeLegendTitleFont
{
  if ( [changeLegendTitleFont state] ) return YES;
  else return NO;
}

- (BOOL) shouldChangeMainTitleFont
{
  if ( [changeMainTitleFont state] ) return YES;
  else return NO;
}

- (BOOL) shouldChangeYTitleFont
{
  if ( [changeYTitleFont state] ) return YES;
  else return NO;
}

- (BOOL) shouldChangeXTitleFont
{
  if ( [changeXTitleFont state] ) return YES;
  else return NO;
}

- (BOOL) shouldChangeTicLabelFont
{
  if ( [changeTicLabelFont state] ) return YES;
  else return NO;
}

- (BOOL) shouldDrawMinorTicMarks
{
  if ( [minorTicMarksOnOff state] ) return YES;
  else return NO;
}

- forceTicMarksOut:sender
{
  ticmarkdir = 1;
  return self;
}

- forceTicMarksIn:sender
{
  ticmarkdir = -1;
  return self;
}

- forceNoTicMarks:sender
{
  ticmarkdir = 0;
  return self;
}

- (int) provideTicMarkDir {return ticmarkdir;}

- changeTicMarksButton: (int)i
{
  if (i == 1)
    [ticMarksOutInOff setTitle:"Tic Marks Out"];
  else if (i == 0)
    [ticMarksOutInOff setTitle:"No Tic Marks"];
  else
    [ticMarksOutInOff setTitle:"Tic Marks In"];
  [ticMarksOutInOff display];
  return self;
}

/* Should the following function be modified to only allow drawing
 * the axes if both the x and y axes are linear?
 */
- (BOOL) shouldDrawAxes
{
  if ( [axesOnOff state] ) return YES;
  else return NO;
}

- maybeDrawAxes:(int) i
{
  return [axesOnOff setState:i];
}

- maybeDrawMinorTicMarks:(int) i
{
  return [minorTicMarksOnOff setState:i];
}

- (int)providelinestyle:(int)aCurve
{
  int   row, cellstate;

  for (row = 0; row < N_LINE_STYLES; row++) {
    cellstate = [ [lineMatrix cellAt:row :aCurve] state];
    if (cellstate == 1) return row;
  }
  return 0;			/* for safety */
}

- (int)providesymbolstyle:(int)aCurve
{
  int   row, cellstate;

  for (row = 0; row < N_SYMBOL_STYLES; row++) {
    cellstate = [ [symbolMatrix cellAt:row :aCurve] state];
    if (cellstate == 1) return row;
  }
  return 0;			/* for safety */
}

- (int)providesymbolsize{  return [symbolSize selectedCol];}
- (int)providelinethickness{  return [lineThickness selectedCol];}

- (float)provideXmin  {return [xMin floatValueAt:0];}
- (float)provideXmax  {return [xMax floatValueAt:0];}
- (float)provideXinc  {return [xInc floatValueAt:0];}
- (float)provideYmin  {return [yMin floatValueAt:0];}
- (float)provideYmax  {return [yMax floatValueAt:0];}
- (float)provideYinc  {return [yInc floatValueAt:0];}

- (float)provideGlobalXmin {return globaldatamin.x;}
- (float)provideGlobalYmin {return globaldatamin.y;}

- resetXmin:(float)aNum { [xMin setFloatValue:aNum at:0]; return self; }
- resetXmax:(float)aNum { [xMax setFloatValue:aNum at:0]; return self; }
- resetXinc:(float)aNum { [xInc setFloatValue:aNum at:0]; return self; }
- resetYmin:(float)aNum { [yMin setFloatValue:aNum at:0]; return self; }
- resetYmax:(float)aNum { [yMax setFloatValue:aNum at:0]; return self; }
- resetYinc:(float)aNum { [yInc setFloatValue:aNum at:0]; return self; }

- resetMinMax:sender
{
  [self niceMinMaxInc];
  [self drawPlot:self];		/* redraw plot automatically */
  return self;
}

- drawPlotButton:(int)state
{
  if (state==0) {
    [plotButton highlight:NO];	/* will display normal title */
  }
  if (state==1) {
    [plotButton highlight:YES];	/* will display alternate title */
  }
  return self;
}

// We make the plotParam object responsible for checking parameters
// before the PlotView object is called.  Thus the PlotView object can
// assume the parameters are OK, and it doesn't have to do any checking.
// Things to check: xinc has the same sign as xmax-xmin (same for y);
// no negative data if log plot requested on x or y axis; there won't be
// too many tic marks requested.
- sanityCheck
{
  float xinc = [self provideXinc];
  float xmax = [self provideXmax], xmin = [self provideXmin];
  float yinc = [self provideYinc];
  float ymax = [self provideYmax], ymin = [self provideYmin];
  int   nticmarks;

  /* First check: no nonpositive data if logarithmic axis */
  if ( [self xaxisLog] ) {
    if (globaldatamin.x <= 0.0 || xmin <= 0.0 || xmax <= 0.0) {
      [xLinLog setState:0];	/* back to linear */
      NXBeep();			/* audible alert */
    }
  }
  if ( [self yaxisLog] ) {
    if (globaldatamin.y <= 0.0 || ymin <= 0.0 || ymax <= 0.0) {
      [yLinLog setState:0];	/* back to linear */
      NXBeep();			/* audible alert */
    }
  }
  /* Second check: xinc has same sign as xmax and xmin */
  if (xinc*(xmax-xmin) <= 0.0) { /* the bad case - avoid infinite loop */
    if (xinc < 0.0) {		/*     in PlotView:drawSelf           */
      xinc = -xinc;
      [self resetXinc:xinc];
      NXBeep();
    }
    if (xmax <= xmin) {
      [self niceMinMaxInc];
      NXBeep();			/* alert */
    }
  }
  /* And similarly for yinc */
  if (yinc*(ymax-ymin) <= 0.0) { /* the bad case - avoid infinite loop */
    if (yinc < 0.0) {
      yinc = -yinc;
      [self resetYinc:yinc];
      NXBeep();			/* alert */
    }
    if (ymax <= ymin) {
      [self niceMinMaxInc];
      NXBeep();			/* alert */
    }
  }
  /* Third check: no more than 100 (say) tic marks on either axis */
  if ( ![self xaxisLog] ) {	/*  linear axis */
    nticmarks = (int) ((xmax - xmin) / xinc) ;
    if (nticmarks > 100) {
      computeNiceLinInc(&xmin, &xmax, &xinc);
      [self resetXmin:xmin];
      [self resetXmax:xmax];
      [self resetXinc:xinc];
      NXBeep();			/* alert */
    }
  }
  if ( ![self yaxisLog] ) {	/*  linear axis */
    nticmarks = (int) ((ymax - ymin) / yinc) ;
    if (nticmarks > 100) {
      computeNiceLinInc(&ymin, &ymax, &yinc);
      [self resetYmin:ymin];
      [self resetYmax:ymax];
      [self resetYinc:yinc];
      NXBeep();			/* alert */
    }
  }

  return self;
}

- drawPlot:sender
{
  if (nfilestotal==0) return self;

  [self drawPlotButton:1];	/* display "Plotting" */
  [self sanityCheck];		/* disallow various bad parameters */
  [canvas display];
  [self drawPlotButton:0];	/* display "Plot" */
  return self;
}

// Allocate enough memory and read the data points
/*
 * WARNING: This code makes the following assumptions:
 * 1. The first line of the input file is "clean", with only the data
 *  x  y1  y2    ...    yn
 * (possibly separated by commas)
 * 2. Other lines of the file may contain arbitrary text, but contain no
 * numerals or periods (these get interpreted as floating point numbers
 * when the file is scanned).
 *
 * It is not easy to make a completely general and bullet-proof scanning
 * routine.  This code is fairly robust and was easy to write.
 */
- (int) readData:(NXStream *)aDataStream :(char *)dataFile
{
  BOOL    inword = NO;
  char    c;
  int     j, size = ALLOCSIZE, tmpint;
  int     oldncurves = ncurvestotal;
  datahunk *pdh, dh;
  
  /* set plot button title "Reading" */
  [plotButton setAltTitle:"Reading"];
  [plotButton highlight:YES];
  NXPing();			/* force plotButton redraw */
  
  if (nfilestotal == 0) {
    datahunkList = [Storage newCount:1
		  elementSize:sizeof(datahunk)
		  description:"{*{float *}{float **}iiffff{BOOL}{BOOL}}"];
    pdh = (datahunk *)[datahunkList elementAt:0];
    if (pdh == NULL) {
      fprintf(stderr, "WEIRD 0: NULL pointer in readData, I quit.\n");
      exit(0);
    }
    nfilestotal = 1;
  }
  else {
    [datahunkList addElement:(void *)&dh];
    pdh = (datahunk *)[datahunkList elementAt:(unsigned)nfilestotal];
    if (pdh == NULL) {
      fprintf(stderr, "WEIRD 1: NULL pointer in readData, I quit.\n");
      exit(0);
    }
    nfilestotal++;
  }
  pdh->filename = (char *)malloc(strlen(dataFile) + 1);
  strncpy(pdh->filename, dataFile, strlen(dataFile) + 1);
  
  /* Figure out the number of curves in the file by reading characters  */
  /* until a newline is encountered; the number of curves is one less   */
  /* than the number of words found.                                    */
  /* We assume the input file is an ascii file; a compressed file will  */
  /* have been pumped through zcat and written to a temporary file.     */
  pdh->ncurves = -1;
  while (1) {
    c = (char)NXGetc(aDataStream);
    if (c == '\n' || c == (char)EOF) {
      break;			/* breaks out of while loop */
    }
    if ((inword==NO) && !(c==' ' || c=='\t')) {
      pdh->ncurves++;
      inword = YES;
    }
    if ((inword==YES) && (c==' ' || c=='\t')) {
      inword = NO;
    }
  }
  if (pdh->ncurves == -1) {	/* couldn't find "\n", give up (after cleanup) */
    [plotButton setAltTitle:"Plotting"]; /* reset plot button */
    [plotButton highlight:NO];
    NXPing();			           /* force redraw */
    free( (void *)(pdh->filename) );
    nfilestotal--;
    return 0;
  }

  /* Now read the data into memory */
  NXSeek(aDataStream, 0L, NX_FROMSTART);
    
  pdh->x = (NXCoord *)malloc( size * sizeof(NXCoord) );
  pdh->y = (NXCoord **)malloc( pdh->ncurves * sizeof(NXCoord *) );
  for (j = 0; j < pdh->ncurves; j++) {
    *(pdh->y+j) = (NXCoord *)malloc( size * sizeof(NXCoord) );
  }
  pdh->npoints = 0;
  while(1) {
    while ( (tmpint=NXScanf(aDataStream, "%f", pdh->x+pdh->npoints)) == 0 ) {
      NXGetc(aDataStream);	/* throw away extraneous characters */
    }
    if (tmpint == EOF) break;	/* break out of the while(1) loop */
    for (j = 0; j < pdh->ncurves; j++) {
// Try to allow extraneous characters here (if scanf returns 0, which means
// it didn't find a number, just do a getc on the input stream to throw that
// character away.  This will allow commas and alphabetic characters in the
// middle of an input line (no digits or periods, though!).
      while( NXScanf(aDataStream, "%f", *(pdh->y+j)+ pdh->npoints) == 0) {
	NXGetc(aDataStream);	/* throw away the next character */
      }
    }
    pdh->npoints++;
    if (pdh->npoints == size) {		/* get more memory */
      size += ALLOCSIZE;
      pdh->x = (NXCoord *)realloc(pdh->x, size * sizeof(NXCoord));
      for (j = 0; j < pdh->ncurves; j++) {
	*(pdh->y+j) = (NXCoord *)realloc( *(pdh->y+j), size * sizeof(NXCoord) );
      }
    }      
  }

  /* Adjust the lineMatrix, symbolMatrix, and legendForm */
  [self adjustPanels:oldncurves :pdh->ncurves];

  /* reset plot button */
  [plotButton setAltTitle:"Plotting"];
  [plotButton highlight:NO];

  [self findMinMax:pdh];
  [self checkLinLog:pdh];

  ncurvestotal += pdh->ncurves;
  return pdh->npoints;
}

/* Might want to make sure INLINE_MATH is defined when math.h is included
 * (for guaranteed fast logarithms?)
 */
- checkLinLog:(datahunk *)pdh
{
  /* Check x and y axes -- do a heuristic test for log/lin.
   * The test employed comes from M. Merriam and xyplot.
   */
  double    scale, linsum, logsum;
  register  double tmp;
  int       i, j;

  /* First test x axis.  */
  if (pdh->datamax.x > 0.0  &&  pdh->datamin.x > 0.0
      && pdh->datamax.x != pdh->datamin.x) {
    scale = fabs( (double)pdh->datamax.x - (double)pdh->datamin.x );
    linsum = 0.0;
    for (j=1; j<pdh->npoints; j++) {
      tmp = ( (double)pdh->x[j]-(double)pdh->x[j-1] )/(double)scale;
      linsum += tmp*tmp;
    }
    scale = log10( (double)pdh->datamax.x/(double)pdh->datamin.x );
    /* what if datamax.x<datamin.x? */
    logsum = 0.0;
    for (i=1; i<pdh->npoints; i++) {
      tmp = log10( (double)pdh->x[i]/(double)pdh->x[i-1] ) / scale;
      logsum += tmp*tmp;
    }
    if (linsum < logsum) {
      pdh->xaxislin = YES;	/* linear axis */
    }
    else {
      pdh->xaxislin = NO;	/* logarithmic axis */
    }
  }
  else {
    pdh->xaxislin = YES;	/* linear */
  }
  /* Now test y axis */
  if (pdh->datamax.y > 0.0  &&  pdh->datamin.y > 0.0
      && pdh->datamax.y != pdh->datamin.y) {
    scale = fabs( (double)pdh->datamax.y - (double)pdh->datamin.y );
    linsum = 0.0;
    for (j=0; j<pdh->ncurves; j++) {
      for (i=1; i<pdh->npoints; i++) {
	tmp = ( (double)*(*(pdh->y+j)+i) - (double)*(*(pdh->y+j)+i-1) )
	  / scale;		/* avoid overflow */
	linsum += tmp*tmp;
      }
    }
    scale = log10((double)pdh->datamax.y/(double)pdh->datamin.y);
    logsum = 0.0;
    for (j=0; j<pdh->ncurves; j++) {
      for (i=1; i<pdh->npoints;i++) {
	tmp = log10( (double)*(*(pdh->y+j)+i)/(double)*(*(pdh->y+j)+i-1) ) / scale;
	logsum += tmp*tmp;
      }
    }
    if (linsum < logsum) {
      pdh->yaxislin = YES;	/* linear axis */
    }
    else {
      pdh->yaxislin = NO;	/* logarithmic axis */
    }
  }
  else {
    pdh->yaxislin = YES;	/* linear */
  }
  return self;
}

// This routine sets the x axis to logarithmic if any one of the files
// is logarithmic, provided that _all_ the x data are positive; similarly
// for the y axis.
- checkGlobalLinLog
{
  int n;
  datahunk *pdh;

  [xLinLog setState:0];		/* linear */
  [yLinLog setState:0];		/* linear */

  for (n=0; n<nfilestotal; n++) {
    pdh = (datahunk *)[datahunkList elementAt:(unsigned)n];
    if ( !pdh->xaxislin ) [xLinLog setState:1]; /* logarithmic */
    if ( !pdh->yaxislin ) [yLinLog setState:1]; /* logarithmic */
  }
  if ( [self xaxisLog] && globaldatamin.x <= 0.0) {
    [xLinLog setState:0];	/* back to linear */
    NXBeep();			/* audible alert */
  }
  if ( [self yaxisLog] && globaldatamin.y <= 0.0) {
    [yLinLog setState:0];	/* back to linear */
    NXBeep();			/* audible alert */
  }
  [xLinLog display];
  [yLinLog display];
  NXPing();			/* temporary */
  return self;
}

- adjustLineStyleMatrix:(int)column :(int)row
{
  /* Adjust the given column of the lineMatrix object, turning off all
   * buttons except for the given row.
   */
  int i;

  for (i = 0; i < N_LINE_STYLES; i++) {
    [ [lineMatrix cellAt:i :column] setState:0];
  }
  [ [lineMatrix cellAt:row :column] setState:1];  
    return self;
}

- redisplayLineStyleMatrix
{
  [ [lineMatrix window] display];
  return self;
}

- adjustSymbolTypeMatrix:(int)column :(int)row
{
  /* Adjust the given column of the symbolMatrix object, turning off all
   * buttons except for the given row.
   */
  int i;

  for (i = 0; i < N_SYMBOL_STYLES; i++) {
    [ [symbolMatrix cellAt:i :column] setState:0];
  }
  [ [symbolMatrix cellAt:row :column] setState:1];  
  return self;
}

- redisplaySymbolTypeMatrix
{
  [ [symbolMatrix window] display];
  return self;
}

- adjustPanels:(int)oldn :(int)newn
{
  /*
   * Resize the linestyle matrix, the symbolstyle matrix, and
   * the legend form.
   * Also arrange to select and highlight only the top button in
   * each column of the linestyle and symbolstyle matrices.
   * This code could stand to be cleaned up.
   */
  char formtitle[80];
  int j, k;

  if (newn == -1) {		/* flag to delete all and start over */
    for (j=oldn-1; j>=1; j--) {
      [lineText removeColAt:j andFree:YES];
      [symbolText removeColAt:j andFree:YES];
      [lineMatrix removeColAt:j andFree:YES];
      [symbolMatrix removeColAt:j andFree:YES];
      [legendForm removeEntryAt:j];
    }
    for (j=0; j<1; j++) {
      if ( [ [lineMatrix cellAt:0 :j] state ] != 1 ) /* seems necessary */
	[ [lineMatrix cellAt:0 :j] setState:1];
      if ( [ [symbolMatrix cellAt:0 :j] state ] != 1 ) /* seems necessary */
	[ [symbolMatrix cellAt:0 :j] setState:1];
      for (k=1; k<N_LINE_STYLES; k++) {
	[ [lineMatrix cellAt:k :j] setState:0];
      }
      for (k=1; k<N_SYMBOL_STYLES; k++) {
	[ [symbolMatrix cellAt:k :j] setState:0];
      }
      sprintf(formtitle, "Curve %d", j+1);
      [legendForm setStringValue:formtitle at:j];
      [legendForm drawCellAt:j];
      sprintf(formtitle, "%d", j+1);
      [[lineText cellAt:0 :j] setStringValue:formtitle]; /* titles on columns */
      [[symbolText cellAt:0 :j] setStringValue:formtitle]; /* titles on columns */
    }
    [legendTitle setStringValue:"Legend" at:0];
    [lineText sizeToCells];
    [symbolText sizeToCells];
    [lineMatrix sizeToCells];
    [symbolMatrix sizeToCells];
    [legendForm sizeToFit];
    [lineThickness setState:1 at:0:0]; /* reset line thickness to thin */
    [symbolSize setState:1 at :0:2]; /* reset symbol size to medium */
    [symbolSize display];
    [lineThickness display];
    [ [lineMatrix window] display]; /* redraw the whole window so extra */
    [ [symbolMatrix window] display]; /* columns get erased               */
    [ [legendForm window] display];
  }

  if ( (oldn == 0) && (newn > 1) ) { /* can only happen first time */
    for (j=1; j<newn; j++) {
      [lineText addCol];
      [symbolText addCol];
      [lineMatrix addCol];
      if ( [ [lineMatrix cellAt:0 :j] state ] != 1 ) /* seems necessary */
	[ [lineMatrix cellAt:0 :j] setState:1];
      /* highlight 1st row new column -- this occurs automatically */
      [symbolMatrix addCol];
      if ( [ [symbolMatrix cellAt:0 :j] state ] != 1 ) /* seems necessary */
	[ [symbolMatrix cellAt:0 :j] setState:1];
      /* highlighting of 1st row new column occurs automatically */
      sprintf(formtitle, "Curve %d:", j+1);
      [legendForm addEntry:formtitle];
      sprintf(formtitle, "Curve %d", j+1);
      [legendForm setStringValue:formtitle at:j];
      [legendForm drawCellAt:j];
      sprintf(formtitle, "%d", j+1);
      [[lineText cellAt:0 :j] setStringValue:formtitle]; /* titles on columns */
      [[symbolText cellAt:0 :j] setStringValue:formtitle]; /* titles on columns */
    }
    [lineText sizeToCells];
    [symbolText sizeToCells];
    [lineMatrix sizeToCells];
    [symbolMatrix sizeToCells];
    [legendForm sizeToFit];
    [lineText display];
    [symbolText display];
    [lineMatrix display];	/* don't need to redraw the window here */
    [symbolMatrix display];
    [legendForm display];
  }
  if ( oldn != 0 ) {		/* must add columns */
    for (j=oldn; j<oldn+newn; j++) {
      [lineText addCol];
      [symbolText addCol];
      [lineMatrix addCol];
      [ [lineMatrix cellAt:0 :j] setState:1];
      /* highlighting of 1st row new column occurs automatically */
      [symbolMatrix addCol];
      [ [symbolMatrix cellAt:0 :j] setState:1];
      /* highlighting of 1st row new column occurs automatically */
      sprintf(formtitle, "Curve %d:", j+1);
      [legendForm addEntry:formtitle];
      sprintf(formtitle, "Curve %d", j+1);
      [legendForm setStringValue:formtitle at:j];
      [legendForm drawCellAt:j];
      sprintf(formtitle, "%d", j+1);
      [[lineText cellAt:0 :j] setStringValue:formtitle];
      [[symbolText cellAt:0 :j] setStringValue:formtitle];
    }
    [lineText sizeToCells];
    [symbolText sizeToCells];
    [lineMatrix sizeToCells];
    [symbolMatrix sizeToCells];
    [legendForm sizeToFit];
    [lineText display];
    [symbolText display];
    [lineMatrix display];	/* don't need to redraw the window here */
    [symbolMatrix display];
    [legendForm display];
  }
  return self;
}

// Go through a particular datahunk and find values for datamin.x,
// datamax.x, datamin.y, datamax.y
- findMinMax:(datahunk *)pdh
{
  int i, j;

  pdh->datamin.x = MAXFLOAT;
  pdh->datamax.x = -MAXFLOAT;
  pdh->datamin.y = MAXFLOAT;
  pdh->datamax.y = -MAXFLOAT;

  for (i = 0; i < pdh->npoints; i++)  {
    pdh->datamin.x = MIN(pdh->datamin.x, pdh->x[i]);
    pdh->datamax.x = MAX(pdh->datamax.x, pdh->x[i]);
  }
  for (j = 0; j < pdh->ncurves; j++) {
    for (i = 0; i < pdh->npoints; i++) {
      pdh->datamin.y = MIN(pdh->datamin.y, *(*(pdh->y+j)+i));
      pdh->datamax.y = MAX(pdh->datamax.y, *(*(pdh->y+j)+i));
    }
  }
  return self;
}

- findGlobalMinMax
{
  int n;
  datahunk *pdh;

  globaldatamin.x = MAXFLOAT;
  globaldatamin.y = MAXFLOAT;
  globaldatamax.x = -MAXFLOAT;
  globaldatamax.y = -MAXFLOAT;
  for (n=0; n<nfilestotal; n++) {
    pdh = (datahunk *)[datahunkList elementAt:(unsigned)n];
    globaldatamin.x = MIN(globaldatamin.x, pdh->datamin.x);
    globaldatamax.x = MAX(globaldatamax.x, pdh->datamax.x);
    globaldatamin.y = MIN(globaldatamin.y, pdh->datamin.y);
    globaldatamax.y = MAX(globaldatamax.y, pdh->datamax.y);
  }
  return self;
}

// Get pleasing values for the min, max, and increments
- niceMinMaxInc
{
  float fmin, fmax, finc;

  fmin = globaldatamin.x;
  fmax = globaldatamax.x;
  if ([self xaxisLog] ) {
    computeNiceLogInc(&fmin, &fmax, &finc);
  }
  else {
    computeNiceLinInc(&fmin, &fmax, &finc);
  }
  [self resetXmin:fmin];
  [self resetXmax:fmax];
  [self resetXinc:finc];

  fmin = globaldatamin.y;
  fmax = globaldatamax.y;
  if ([self yaxisLog] ) {
    computeNiceLogInc(&fmin, &fmax, &finc);
  }
  else {
    computeNiceLinInc(&fmin, &fmax, &finc);
  }
  [self resetYmin:fmin];
  [self resetYmax:fmax];
  [self resetYinc:finc];
  return self;
}

// Use the OpenPanel object to get a filename
- open:sender
{
  static const char *const fileTypes[2] = {NULL, NULL};
				/* this is supposedly all ASCII files */
  char  fname[1024];
  char  tempfname[256], command[512];
  id openPanel = [[OpenPanel new] allowMultipleFiles:NO];

  if ([openPanel runModalForTypes:fileTypes])  {
    strncpy(fname, (char *)[openPanel filename], 1024);
    // Check to see if we are trying to open a compressed file:
    if (fname[strlen(fname)-1]=='Z' && fname[strlen(fname)-2]=='.') {
      // set plot button title:
      [plotButton setAltTitle:"Uncompressing"];
      [plotButton highlight:YES];
      NXPing();			/* force plotButton redraw */
      // Uncompress the file into a temporary file:
      strcpy(tempfname, "/tmp/file000000.xyp");
      NXGetTempFilename(tempfname, 9);
      sprintf(command, "zcat %s > %s\n", fname, tempfname);
      system(command);		/* no error checking */
      // Now just go ahead and open the temporary file:
      [self openFile:tempfname];
      // After returning from the openFile it is safe to unlink:
      unlink(tempfname);
    }
    else {
      [self openFile:fname];
    }
  }
  return self;
}

- openFile:(char *)dataFile
{
  NXStream *dataStream;

  if ((dataStream = NXMapFile(dataFile, NX_READONLY)) == NULL)  {
    NXRunAlertPanel("Open", "Cannot open %s", "OK", NULL, NULL, dataFile);
    return self;
  }

  if ([self readData:dataStream :dataFile] == 0)  {
    NXRunAlertPanel("Read", "Couldn't read any data from %s", "OK",
		    NULL, NULL, dataFile);
    NXCloseMemory(dataStream, NX_FREEBUFFER);
    return self;
  }
  NXCloseMemory(dataStream, NX_FREEBUFFER);

  [self plotPrepAndDraw];
  return self;
}

- plotPrepAndDraw
{
  [canvas initializeLegendBox]; /* would like to get this out of here! */

  /* Check for linear or log on x and y axes */
  [self checkGlobalLinLog];

  [self findGlobalMinMax];

  /* Only check and reset min/max if this is the first file */
  if (nfilestotal == 1) {
    [self niceMinMaxInc];
  }

  [self drawPlot:self];
    
  return self;
}

- saveEPS:sender
{
  id savePanel = [[SavePanel new] setRequiredFileType:"eps"];
  char  *eps_fileName;	// Name of the EPS file for output

  if ([savePanel runModal])  {
    eps_fileName = (char *) calloc(strlen([savePanel filename])+1, sizeof(char));
    strcpy(eps_fileName, [savePanel filename]);
    [canvas savePSCode:eps_fileName];
  }

  return self;
}

@end
