
/* Generated by Interface Builder */

/*
 * This code is essentially copied from the AtYourService example
 * of Henry Krempel.
 */

#import "PlotDelegate.h"
#import "ServicesHandler.h"
#import "Plot.h"
#import <appkit/Application.h>
#import <appkit/Listener.h>
#import <appkit/Pasteboard.h>
#import <appkit/Panel.h>
#import <strings.h>

@implementation PlotDelegate

- appDidInit:sender
{
  [[NXApp appListener] setServicesDelegate:self];
  [servicesHandler serviceSetState];
  return self;
}

/* This method takes data from a pasteboard and sends it to be plotted. */
- plotFromPasteboard:pb userData:(const char *)userData error:(char **)errorMessage
{
  char *data;
  int length;
  const char *const *types;
  int hasAscii, i;

  types = [pb types];
  hasAscii = 0;
  for (i = 0; !hasAscii && types[i] ; i++) 
    if (!strcmp(types[i], NXAsciiPboardType)
	|| !strcmp(types[i], NXTabularTextPboardType)) hasAscii = 1;

  if (hasAscii) {
    [pb readType:NXAsciiPboardType data:&data length:&length];

    if (data && length) {
      NXStream *dataStream = NXOpenMemory(data, length, NX_READONLY);
      if ([plotParam readData:dataStream :"pasteboard"] == 0) {
	NXRunAlertPanel("Read", "Couldn't read any data from %s", "OK",
			NULL, NULL, "pasteboard");
      }
      [plotParam plotPrepAndDraw];
    }
    else *errorMessage = "No data in your selection.";
  } 
  else *errorMessage = "No ASCII text found in your selection.";

  return self;
}

@end
