/*	makeheader.c
	Create what has to go in an "__ICON __header" segment of the
	Mach-O file to make the Workspace see icons and launch program.
*/

#include "port.h"

main(int argc, char **argv)
{
	FILE *f;int i;
	char fname[80];
	if (argc<2) {
		puts("Make .iconheader file.  Usage is\n"
			"makeheader progname {suffix...}\n"
			"progname = name of executable file\n"
			"suffix = suffixes of data files, they get same icon");
		exit(1);
		}
	strcpy(fname,argv[1]); strcat(fname,".iconheader");
	f = fopen(fname,"w");
	if (!f) {
		printf("Can't open '%s', %s\n",fname,strerror());
		exit(1);
		}
	fprintf(f,"F\t%s\t%s\tapp\n",argv[1],argv[1]);
	for (i=2; i<argc; i++) fprintf(f,"S\t%s\t%s\tapp\n",argv[i],argv[1]);
	fclose(f);
	}
