#include "mach.h"

main() {
	struct vm_statistics s;
	int pagek; int m,t;
	unsigned int address,offset;
	int protection,maxprotection,inheritance,object_name;
	unsigned int size,shared;
	static int initdata = 4;
	static int bssdata;

	_vm_statistics(task_self_,&s);
	pagek = s.pagesize/1024;
	printf("------- vm_statistics according to the Mach Kernel: -------\n");
	printf("Each page has %d bytes (%dK)\n",s.pagesize,pagek);
	printf("%4d(%dK) free\n",s.free_count,s.free_count*pagek);
	printf("%4d(%dK) active\n",s.active_count,s.active_count*pagek);
	printf("%4d(%dK) inactive\n",s.inactive_count,s.inactive_count*pagek);
	printf("%4d(%dK) wired down\n",s.wire_count,s.wire_count*pagek);
	t=(s.free_count+s.active_count+s.inactive_count+s.wire_count)*pagek;
	m=((t-1)/1024+1)*1024;
	printf("%4d(%dK) unaccounted for\n",(m-t)/pagek,m-t);
	printf("%4d(%dM) total\n",m/pagek,m/1024);
	printf("%d vm pages mapped as zero-fill\n",s.zero_fill_count);
	printf("# of pages reactivated = %d\n",s.reactivations);
	printf("# of pageins = %d\n",s.pageins);
	printf("# of pageouts = %d\n",s.pageouts);
	printf("# of faults = %d\n",s.faults);
	printf("# of copy-on-write faults = %d\n",s.cow_faults);
	printf("object cache lookups = %d\n",s.lookups);
	printf("object cache hits = %d\n",s.hits);

	printf("\nMemory map of this task:\n"
		  "   start   length      end P M I S pager[offset]\n");
	address = 0;
	while (vm_region(task_self_,&address,&size,&protection,&maxprotection,
				  &inheritance,&shared,&object_name,&offset)==0) {
		printf("%8x %8x %8x %d %d %d %d %d[%x]\n",
			  address,size,address+size,protection,maxprotection,
			  inheritance,shared,object_name,offset);
		address += size;
		}

	printf("\nInteresting locations:\n");
	{extern printf();
	printf("main is at %x\n",main);
	 printf("printf is at %x\n",printf);
	 printf("if printf is a jump, it points to %x\n",
		   *(unsigned *)((void *)printf+2));
	 printf("A piece of initialized data is at %x\n",&initdata);
	 printf("A piece of bss data is at %x\n",&bssdata);
	 printf("Stack pointer is at %x\n",&shared);
	 }
	printf("\nMalloc says:\n");
	mstats();
	printf("That last 8K seems to be allocated by printf.\n");
	/* include DPS library... */
	DPSAddFD(0,0,0,0,0);
	}
