#pragma .h  #import <objc/Object.h> 
#pragma .h  #import "Glyph.h"
#import "Terminator.h"
#import <appkit/Application.h>
/**
 ** Terminators are often called "sentinels"
 ** in CS literature.  They are used stop off
 ** the is, than, and ancestor pointers in
 ** a glyph. They generally function a
 ** the basis of recursive calls on a 
 ** TTree.  There really is only one
 ** Terminator, returned by the new message.
 ** If we could get doesNotUnderstand: to
 ** work with factory objects, 
 ** then this class could be all
 ** class methods.
 **/ 

static id _soleInstanceOfTerminator = nil ;

@implementation Terminator: Object
{ 
}

+ new ;
{ if(!_soleInstanceOfTerminator)
    _soleInstanceOfTerminator = [super new] ;
  return _soleInstanceOfTerminator ;
}

- doesNotRecognize: (SEL)aSelector ;
{ // if I don't recognize something,
  // I just return
  return self ;
}

- enlist: (Glyph *) aGlyt ;
{ // I will terminate this Glist
  aGlyt->then = (Glyph *) self ;
  return aGlyt ;
}

-hitTest: (NXPoint *) aPnt ;
{ return nil ;
}

- (char *) iam ;
// remove: debugging purposes only
{ return "Term" ;
}

- (BOOL) isTerminator ;
{ return YES ;
}

- (BOOL) precedes: (Glyph *) aGlyph ;
{ // Terminators cannot precede anything
  return NO ;
}
 

- test: (int) anInt ;
{ // remove when you are satisfied...
  [NXApp printf: "T%d\n", anInt] ;
  return self ;
}


@end