/*
 * extract.c:
 *
 * Make a list of all of the nibs in an executable; extract them and put
 * them into files ending with ".nib"
 *
 */

#include <libc.h>

FILE	*nibfile;
char	**niblist;
int	nibs=0;
char	*prog;


void	usage()
{
	printf("usage: extract <program-to-extract>\n");
	exit(1);
}

void	extract(char *nibname)
{
	char	buf[512];
	char	filename[512];
	char	*cc;
	struct	stat	sbuf;

	strcpy(filename,nibname);

	/* see if the last four characters are ".nib".  If not, then add
	 * them...
	 */

	printf("Extracting %s ");

	cc	= filename+strlen(filename);
	if(cc[-4]!='.'
	   || cc[-3]!='n'
	   || cc[-2]!='i'
	   || cc[-1]!='b'){
		strcat(filename,".nib");
		printf("--> %s ",filename);
	}

	sprintf(buf,"/bin/segedit -extract __NIB %s %s %s",
		nibname,filename,prog);
	system(buf);

	stat(filename,&sbuf);
	printf("\n");
	fprintf(nibfile,"%s %s %ld\n",nibname,filename,sbuf.st_mtime);
}

/* Process a section; capture the section name and look for
 * segment name __NIB
 */
void	do_section(FILE *pout)
{
	char	sectname[256];
	char	segname[256];
	char	*cc;

	sectname[0]	= '\000';
	segname[0]	= '\000';
	
	fgets(sectname,sizeof(sectname),pout);
	if(strncmp(sectname,"  sectname ",11)){
		printf("section: %s",sectname);
		return;
	}

	if((cc=index(sectname,'\n'))!=0){
		*cc = '\000';
	}

	fgets(segname,sizeof(segname),pout);
	if(strcmp(segname,"   segname __NIB\n"))	return;

	/* I've got a NIB; add it to the list. */

	niblist		= realloc(niblist,sizeof(char *) * (nibs+1));
	niblist[nibs]	= malloc(strlen(sectname)+1);
	strcpy(niblist[nibs],sectname+11);
	nibs++;
	return;
}

int	main(int argc,char **argv)
{
	FILE	*pout;
	char	*buf;
	int	i;

	if(argc!=2){
		usage();
	}

	nibfile	= fopen("NIBLIST","w");

	niblist	= malloc(0);
	nibs	= 0;

	prog 	= argv[1];
	buf	= alloca(strlen(prog)+20);
	sprintf(buf,"otool -l %s",prog);

	pout	= popen(buf,"r");
	while(!feof(pout)){
		char	lbuf[256];

		fgets(lbuf,sizeof(lbuf),pout);
		if(!strcmp(lbuf,"Section\n")){
			do_section(pout);
		}
	}
	pclose(pout);

	printf("Program: %s\nnibs: %d\n",prog,nibs);

	/* Now extract each nib... */
	for(i=0;i<nibs;i++){
		extract(niblist[i]);
	}

}

