#import "Workspace.h"
#import "Background.h"
#import <appkit/Application.h>
#import <appkit/publicWraps.h>
#import <dpsclient/wraps.h>
#import <appkit/defaults.h>

@implementation Workspace

+ getFrameRect:(NXRect *)fRect forContentRect:(const NXRect *)cRect
	 style:(int)aStyle
{
  fRect->origin.x=fRect->origin.y=0;
  [NXApp getScreenSize:&(fRect->size)];
  return self;
}
+ getContentRect:(NXRect *)cRect forFrameRect:(const NXRect *)fRect
	   style:(int)aStyle
{
  cRect->origin.x=cRect->origin.y=0;
  [NXApp getScreenSize:&(cRect->size)];
  return self;
}
+ (NXCoord)minFrameWidth:(const char *)aTitle forStyle:(int)aStyle
	      buttonMask:(int)aMask;
{
  NXSize s;
  [NXApp getScreenSize:&s];
  return s.width;
}

- initContent:(const NXRect *)cRect style:(int)aStyle
      backing:(int)bufferingType buttonMask:(int)mask defer:(BOOL)flag
{
  [super initContent:cRect style:NX_TOKENSTYLE
	     backing:NX_RETAINED buttonMask:0 defer:NO];
  [self useOptimizedDrawing:YES];
  PSsetwindowlevel( -1, [self windowNum]);
  [self removeFromEventMask:(NX_LMOUSEDOWNMASK | NX_LMOUSEUPMASK
  			   | NX_MOUSEMOVEDMASK | NX_LMOUSEDRAGGEDMASK
			   | NX_MOUSEENTEREDMASK | NX_MOUSEEXITEDMASK
			   | NX_KEYDOWNMASK | NX_KEYUPMASK
			   | NX_CURSORUPDATEMASK)];
  return self;
}
- appDidInit:sender
{
  NXRect r={{0, 0}};
  const char *picture=NXReadDefault( "Background", "Image");
  [NXApp getScreenSize:&(r.size)];
  [self placeWindowAndDisplay:&r];
  [self orderWindow:NX_ABOVE relativeTo:0];
  if( picture)	[[background setImageNamed:picture] display];
  return self;
}
-(BOOL)appAcceptsAnotherFile:sender	{ return YES; }
-(int)appOpenFile:(const char *)filename type:(const char *)aType
{
  [[background setImageNamed:filename] display];
  NXWriteDefault( "Background", "Image", filename);
  return YES;
}
@end
