//
//	Unix utility to read an image from either eps or tiff file 
//	and convert to a tiff-file.
//
//		(c) A.Windemuth, distribute freely but don't sell
//
 
#include <stdio.h>
#include <libc.h>
#include <appkit/NXImage.h>
#include <appkit/Application.h>
#include <appkit/Text.h>
#import <dpsclient/wraps.h>

#include "PSsplat.h"
#include "Background.h"
#include "Workspace.h"

void usage(char *fn) {
    fprintf(stderr,"Usage: %s [-p] <image-file>\n",fn);
    exit(1);
}

void main(int argc, char **argv)
{
	const char *fn;
	NXRect r={{0, 0}};
	id window;
	id view;
	BOOL perm;
	
 	if (argc<2 || argc>3) usage(argv[0]);
	fn = argv[1];
	perm = NO;
	if (strcmp(argv[1],"-p")==0) {
	    perm = YES;
	    if (argc<3) usage(argv[0]); else fn = argv[2];
	}
	while(!(NXApp = [Application new])) sleep(1);
	[NXApp getScreenSize:&(r.size)];
	view = [[Background alloc] initFrame:&r];
	[view setImageNamed:fn];
	[view setPermanent:perm];
	window = [[Workspace alloc] initContent:&r style:NX_TOKENSTYLE 
	    backing:NX_NONRETAINED  buttonMask:0 defer:YES];
	[window setContentView:view];
	[window useOptimizedDrawing:NO];
	[window removeFromEventMask:(NX_LMOUSEDOWNMASK | NX_LMOUSEUPMASK
  			   | NX_MOUSEMOVEDMASK | NX_LMOUSEDRAGGEDMASK
			   | NX_MOUSEENTEREDMASK | NX_MOUSEEXITEDMASK
			   | NX_KEYDOWNMASK | NX_KEYUPMASK
			   | NX_CURSORUPDATEMASK)];
	PSsetwindowlevel(-1, [window windowNum]);
	[window placeWindowAndDisplay:&r];
	[window display];
	[window orderWindow:NX_ABOVE relativeTo:0];
	NXPing();
	if (!perm) while(YES) sleep(1000); else exit(0);
}

