/* 
   dim.c: written for the NeXT computer (using 1.0 and maybe 2.0)

   general usage: dim [0-61]

   example usage: dim 52

   purpose: Dims the screen to some specified brightness.  Returns the
            original brightness to the calling environment.  If dim is
            invoked from within a shell script, the original brightness
            may be determined by checking the value of the special 
            environment variable $?.

   author: written by John W. Garnett on December 12, 1990 (modified 2/23/91)

   email: garnett@cs.utexas.edu

   compile using: cc dim.c -o dim

   relevant manual pages: evs and ioctl

   comments: yes, I know that preferences lets one set the autodim time
     so that the screen will automatically dim after a certain period
     of time.  However, the degree of dimming that occurs is fixed at
     1/4 the current level which I don't think is dim enough.  Ideally
     there should be some way to control the degree of dimming that
     automatically occurs.  However, since there doesn't appear to be
     any way to do so, I've offer this hack.  Do with it what you will.

   disclaimer: no claims are made as to the suitability of this software for
     any purpose.  Use at your own risk.
*/

#include <stdio.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <nextdev/evsio.h>

#define EVS_DEVICE "/dev/evs0"

/* open the event status device (see man page for evs) */

int openEvs()
{
	int fd;

	fd = open(EVS_DEVICE,O_RDWR,0660);
	if (fd < 0) {
		fprintf(stderr,"error: couldn't open %s\n",EVS_DEVICE);
		exit(2);
	}
	return(fd);
}

/* return brightness level as integer value between 0 and 61 */

unsigned long getBrightness()
{
	unsigned long original;
	int fd;

	fd = openEvs();
	ioctl(fd,EVSIOCB,&original);
	close(fd);
	return(original);
}

/* set brightness to level and return previous brightness */

int setBrightness(level)
unsigned long level;
{
	unsigned long original;
	int fd;

	fd = openEvs();
	original = getBrightness();
	ioctl(fd,EVSIOSB,&level);
	close(fd);
	return(original);
}

int main(argc,argv)
int argc;
char **argv;
{
	unsigned long request;

	if (argc != 2) {
		fprintf(stderr,"usage: %s [0-61]\n",argv[0]);
		exit(1);
	}
	sscanf(argv[1],"%lu",&request);
	return(setBrightness(request));
}
