#import <sound/sounddriver.h>
#import <sound/soundstruct.h>
#import "Recorder.h"

/* Tag for DMA messages coming from the DSP */
#define READ_TAG	1

#define HIGH_WATER	((512+256)*1024)
#define LOW_WATER	(512 * 1024)
#define BYTES_PER_16BIT	2
#define REGION_SIZE	HIGH_WATER
#define READ_BUF_SIZE	(vm_page_size / BYTES_PER_16BIT)

@interface DSPRecorder:Recorder
{
  int bytesEnqueued;		/* # of samples allocated for DSP buffers */
  snddriver_handlers_t msgHandlers;
  SNDSoundStruct *dspProgram;	/* DSP program to load and run */
  port_t devicePort;
  port_t ownerPort;
  port_t commandPort;
  port_t streamPort;
  port_t replyPort;
}

+ new;
/*
 * Factory method to instantiate a new recorder object.
 */

/***
 ***
 *** Methods inherited from the Recorder object
 ***
 ***/

- prepare;
/*
 * Prepare to record, state => REC_PAUSED
 */

- run;
/*
 * Start recording, state => REC_RUNNING
 */

- pause;
/*
 * Pause the recording, state => REC_PAUSED
 */

- stop;
/*
 * Stop recording, state => REC_STOPPED
 */

/***
 ***
 *** Internal methods 
 ***
 ***/

- setDspProgram :(SNDSoundStruct *)dsp_program;
- (SNDSoundStruct *)dspProgram;
- (snddriver_handlers_t *)msgHandlers;
- recordedData :(int)tag :(char *)data :(int)nbytes;
- updateStream;

@end

