#import <objc/Object.h>

/* The states that the recorder can be in. */
typedef enum {
  REC_STOPPED,
  REC_PAUSED,
  REC_RUNNING,
  N_REC_STATES
  } Rec_state_t;
  
@interface Recorder:Object
{
  int bytesRecorded;		/* # of bytes recorded since setup */
  id delegate;			/* the target of notification messages */
  Rec_state_t recorderState;	/* current state of the recorder object */
}

+ new;
/*
 * Factory method to instantiate a new recorder object.
 */

/***
 ***
 *** The main user-visible methods
 ***
 ***/

- prepare;
/*
 * Prepare to record, state => REC_PAUSED
 */

- run;
/*
 * Start recording, state => REC_RUNNING
 */

- pause;
/*
 * Pause the recording, state => REC_PAUSED
 */

- stop;
/*
 * Stop recording, state => REC_STOPPED
 */

- (Rec_state_t)state;
/*
 * Returns the current state of the recording object
 */

- (int)bytesRecorded;
/*
 * Returns the number of bytes recorded since the last call to setup
 */

- delegate;
/*
 * Returns the current delegate.
 */

- setDelegate:anObject;
/*
 * Sets the delegate of the recoder
 */

@end


/***
 ***
 *** Description of the Recorder's delegate
 ***
 ***/

@interface RecorderDelegate:Object

- willRecord :recorder;
/*
 * Called whenever the recorder is about to start recording.
 */

- didRecord :recorder;
/*
 * Called whenever the recorder stops recording.
 */

- recordData :recorder :(char *)data :(int)nbytes;
/*
 * Called whenever the recorder has received sound data.
 */

@end



