/*
 * Recorder.m
 * A digital sound recording object.
 * Author: Robert D. Poor, NeXT Technical Support
 * Copyright 1989 NeXT, Inc.  Next, Inc. is furnishing this software
 * for example purposes only and assumes no liability for its use.
 * 07-SEP-89
 */

/*
 * The Recorder object provides a common superclass for a family of
 * recording objects.  This object must be subclassed in order to do
 * anything useful.  See the DSPRecorder for an example.
 */

#import <stdio.h>
#import <appkit/Panel.h>
#import <sound/sounddriver.h>
#import <sound/soundstruct.h>
#import "Recorder.h"
#import "errors.h"

@implementation Recorder:Object

/*
 * Create a new Recorder object.
 */
+ new
{
  self = [super new];

  bytesRecorded = 0;
  recorderState = REC_STOPPED;
  return self;
}

- stop
{
  NXRunAlertPanel("Alert",
		  "The method %s must be implemented in a subclass",
		  NULL,NULL,NULL,"stop");
  return self;
}

- prepare
{
  NXRunAlertPanel("Alert",
		  "The method %s must be implemented in a subclass",
		  NULL,NULL,NULL,"prepare");
  return self;
}

- run
{
  NXRunAlertPanel("Alert",
		  "The method %s must be implemented in a subclass",
		  NULL,NULL,NULL,"run");
  return self;
}

- pause
{
  NXRunAlertPanel("Alert",
		  "The method %s must be implemented in a subclass",
		  NULL,NULL,NULL,"pause");
  return self;
}

- (Rec_state_t)state
/*
 * Returns the current state of the recording object
 */
{
  return recorderState;
}

- (int)bytesRecorded;
/*
 * Returns the number of bytes recorded since the last call to setup
 */
{
  return bytesRecorded;
}

- delegate
/*
 * Returns the current delegate.
 */
{
  return delegate;
}

- setDelegate:anObject
/*
 * Sets the delegate of the recoder
 */
{
  delegate = anObject;
}

@end

