/*
 *    Filename:	CompressApp.m 
 *    Created :	Mon Jul  1 16:13:24 1991 
 *    Author  :	Vince DeMarco
 *		<demarco@cpsc.ucalgary.ca>
 */


/* Generated by Interface Builder */
#import <stdlib.h>
#import <stdio.h>
#import <strings.h>

#import <appkit/OpenPanel.h>
#import <appkit/Pasteboard.h>
#import <appkit/Listener.h>

#import <mach.h>
#import <mach_interface.h>

#import "CompressApp.h"
#import "Compress.h"

@implementation CompressApp

+ new
{
    self = [super new];
    OpenPanelObject = [OpenPanel new];
    [OpenPanelObject allowMultipleFiles:YES];
    [self setDelegate:self];
    return(self);
}

- free
{
    [OpenPanelObject free];
    [super free];
    return(self);
}
      
- (int)openFile:(const char*)filename ok:(int *)flag
{
    char tempfilename[1024];

    strcpy(tempfilename,filename);
    [CompressObject uncompressFile:tempfilename];
    *flag = YES;
    return(0);
}
- (BOOL)appAcceptsAnotherFile:sender
{
    return(YES);
}

- compressfile:sender
{
    char   tempfilename[1024];
    const char  *directory;
    char **file_list;
    int    counter =0;

    [OpenPanelObject setTitle:"Compress File"];
    [OpenPanelObject setRequiredFileType:"\000"];

    if ([OpenPanelObject runModal] != 0){
	file_list = (char **)[OpenPanelObject filenames];
	directory = (const char *)[OpenPanelObject directory];

	while(file_list[counter] != NULL){
	    sprintf(tempfilename,"%s/%s",directory,file_list[counter++]);
	    [CompressObject compressFile:tempfilename];	    
	}
    }

    return(self);
}

- uncompressfile:sender
{
    char   tempfilename[1024];
    const char  *directory;
    char **file_list;
    int    counter =0;
    char *filetypes[3] = { {"Z"},{NULL}};

    [OpenPanelObject setTitle:"UnCompress File"];

    if ([OpenPanelObject runModalForDirectory:"." file:NULL types:filetypes] != 0){
	file_list = (char **)[OpenPanelObject filenames];
	directory = (const char *)[OpenPanelObject directory];

	while(file_list[counter] != NULL){
	    sprintf(tempfilename,"%s/%s",directory,file_list[counter++]);
	    [CompressObject uncompressFile:tempfilename];	    
	}
    }

    return(self);
}
- appDidInit:sender
{
    [[NXApp appListener] setServicesDelegate:self];
    return(self);
}
- compressDocument:myPasteboard userData:(const char*)userData error:(char**)message
{
    char         *data;
    int           length;
    char         *temp;
    char         *temp2;

    const NXAtom *myTypes;
    
    myTypes = [myPasteboard types]; // You need this for some stupid idiotic reason

    if ([myPasteboard readType:NXFilenamePboardType data:&data length:&length]){
	data[length]= '\000';
	if ((temp = index(data,'\t')) == NULL){  // Check if multiple files selected
	    [CompressObject compressFile:data];	    	
	}else{
	    temp2 = data;
	    while(temp != NULL){
		*temp = '\000';
		temp = temp+1;
		[CompressObject compressFile:temp2];
		temp2 = temp;
		temp = index(temp2,'\t');
	    }
	    [CompressObject compressFile:temp2];
	    
	}
	vm_deallocate(task_self(),(vm_address_t)data,(vm_size_t)length);
    }
    return(self);
}
@end
