.\" Copyright 1991, Karl Kraft
.\" You are free to study this program, and use any indistinguishable part of it in any program, without permission of any kind.
.TH SQUEEZEIMAGE 1 "July 24, 1991" "Ensuing Technologies"
.SH NAME
squeezeImage \- compress/uncompress TIFF files on the NeXT computer
.SH SYNOPSIS
.B squeezeImage inputfile outputfile
[
.B level
]
.SH DESCRIPTION
This program was designed as a utility to compress large groups of TIFF images, with the best (read smallest size) possible compression.  Some images will compress better with Packbits than LZW or vice-versa.  This program automates the task of determining which compression method is best.  
.PP
.B
Level
indicates how much compression you wish to perform.  
.PP
0 means you do not want the file compressed, and would like it to be un-compressed if possible. 
.PP
1 means that 
.B squeezeImage 
should try Packbits. 
.PP
2 means that 
.B squeezeImage 
should try Packbits and LZW.  [default]
.HP
3+, allow 
.B squeezeImage
to use JPEG which almost always results in a JPEG compressed image.  However, using JPEG will cause a loss in quality that cannot be undone.  The level is passed to the JPEG compression software as the user-settable factor. A higher number will compress more, but will also cause more information loss.
.PP
The compression is done in memory, so you can specify the same name for 
.B inputfile 
and 
.B outputfile.
.SH AUTHOR
Karl Kraft- Karl_Kraft@bodi.portal.com
.SH CREDITS
This program is the result of my interest in creating raytraced movies.  This was inspired by the programs of  Mark VandeWettering  (MTV_ray_engine) and David S. Joerg (MovieApp).

I would also like to thank Robert Poor (NeXT) for originally showing me the mix of C and Objective-C that I used in squeezeImage.
.SH COMING SOON
ability to compress stdin/stdout
.SH SEE ALSO
tiffutil(1)
.SH BUGS
The loss of quality from compresssing with JPEG cannot be undone.

While compressing 24 bit color images with level 2, I have managed to make the resulting file unreadable. I have had no problems with B&W images.  I think this may be a problem with the NeXT routines rather than squeezeImage.

Not much error checking is done (files, permissions, is inputfile is a TIFF file).

Be careful that you don't accidentally type
.B squeezeImage somefile 2, 
when you mean to type
.B squeezeImage somefile somefile 2.

JPEG compression can be used only for images that have a depth of at least 4 bits per sample. (Not my rule).

You may only have one image in the TIFF file.

Report bugs, comments, and suggestions to the Author.
