
/* Not generated by Interface Builder */

/*
 * This is an Animator class which is sort of different from the
 * Animator found in the Stopwatch program.  It is a bit more standalone,
 * as I wanted to be able to create objects which only animated if they
 * were the target of an Animator, or if they had an Animator as an outlet.
 * (The Animator class allows the Animator to be either an outlet, or to
 * have a target, and animate in much the same way.)  See the accompanying
 * documentation for more help (Animator.wn).
 */

#import <objc/Object.h>
#import <appkit/Application.h>

@interface Animator:Object
{
    id target;			// The thing we are animating.
    DPSTimedEntry te;		// the timed entry we are using.
    BOOL running;		// YES if we are running.
    float timing;		// the current timing we are using.
    float threshold;		// the threshold we are running at.
    SEL action;			// message to send to target.
    
    double startTime;		// when we started.
    double elapsed;		// time between current call and the original.
}

+ new;				// create a new Animator.

// These routines allow the user to set up the default values for Animator
// objects.  Using these factory methods, a subclass may easily change the
// Animator's actions by calling these methods in an initialize factory
// method.
+ setDefaultTiming:(float)dtiming;
+ setDefaultThreshold:(float)dthreshold;
+ setDefaultAction:(SEL)daction;
+ setDefaultRunning:(BOOL)state;

- free;				// free the Animator up.

// These routines set up the animator according to the user's desires.
- setTarget:anObject;		// calls setAnimator if anObject implements.
- target;
- setTiming:(float)timing;
-(float)timing;
- setThreshold:(float)threshold;
-(float)threshold;
- setAction:(SEL)aSelector;
-(SEL)action;
- setRunning:(BOOL)state;
-(BOOL)running;
-(double)doubleValue;		// return the amount of time since last call.
-(float)floatValue;		// return as a float.
-(int)intValue;
- resetValue:(double)value;	// reset the start time to value.
- resetValue;			// reset start time to now.

// sendAction:to: sends theAction with parameter self to theTarget.  If
// theAction is NULL, or theTarget is nil, nothing is sent.  sendAction
// sends the animator's action to its target.
- sendAction:(SEL)theAction to:theTarget;
- sendAction;

// These are to be hooked up to various user interface objects, such as
// buttons and sliders.
- start:sender;			// start the Animator.
- stop:sender;			// stop the Animator.
- toggleRun:sender;		// toggle the Animator's state.
- takeTimingFrom:sender;	// to hook up a slider.
- takeRunningFrom:sender;	// set state by sender.

// These routines are for reading and writing the animator.
- copy;
- awake;
- write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;

@end

// This is stuff which the target may wish to implement.  The Animator class
// checks to see that the target can run them before calling it.
@interface AnimatorTarget:Object
{
}

- setAnimator:sender;

@end
