#import "BackApp.h"
#import <appkit/Window.h>
#import "Animator.h"
#import "BounceView.h"
#import <appkit/defaults.h>
#import <stdlib.h>
#import <appkit/Bitmap.h>
#import <appkit/Control.h>

@implementation BackApp

+ new			// create the new application, and make us its delegate.
{
  self = [super new];
  [self setDelegate:self];
  return self;
}
- setIconView:anObject		// let me know where the view is.
				// Note that the View is in the Speed window,
				// but "hidden" below the bottom.  Resize from
				// IB to "find" it.  Size makes no difference here.
				// It may not need to be hidden, either, as it
				// is moved right away anyway.
{
  iconView=anObject;
  return self;
}
- setSpeedSlider:anObject	// let me know where the slider is.
{
  speedSlider=anObject;
  return self;
}
- appDidInit:sender			// set up in the icon, and set the timing.
{
  NXRect r;
  const char *t;
  					// So that clicking in background doesn't
					// activate BackBounce.
  [[iconView window] removeFromEventMask:NX_LMOUSEDOWNMASK];
  					// Moves background behind everyone else.
  _NXSetWindowLevel([[iconView window] windowNum], -1);
  
  if( t=NXGetDefaultValue( [NXApp appName], "Speed"))	// set the speed.
    [[iconView animator] setTiming:atof( t)];
  [[iconView animator] start:iconView];		// and start the animator.
  
  [speedSlider setDoubleValue:[[iconView animator] timing]];	// fix the slider.

  [[iconView window] orderFront:self];			// get us visible.

  return self;
}
- terminate:sender			// store the defaults, and go away.
{
  char s[ 20];
  sprintf( s, "%f", [[iconView animator] timing]);	// write to string,
  NXWriteDefault( [self appName], "Speed", s);		// and store it.
  return [super terminate:sender];
}
- appPowerOffIn:(int)ms andSave:(int)aFlag	// catch Workspace logout.
{
  return [self terminate:self];
}

- windowWillResize:sender toSize:(NXSize *)s	// Just limits a window's size.
{
  NXRect r;
  [sender getFrame:&r];
  s->height=r.size.height;			// kindly change it back.
  return self;
}

@end
